#include "config.h"
#include "cmap.h"
#include "crandom.h"

void map_setval(_map* map, int x, int y, unsigned short d)
{
	x &= MAP_SIZEX - 1;
	y &= MAP_SIZEY - 1;
	map->data[(y << MAP_SIZEX_LOG2) + x] = d;
}

unsigned short map_getval(_map* map, int x, int y)
{
	x &= MAP_SIZEX - 1;
	y &= MAP_SIZEY - 1;
	return map->data[(y << MAP_SIZEX_LOG2) + x];
}

void map_init(_map* map)
{
	int i, j;
	for(i = 0; i < (1 << MAP_SIZEX_LOG2); i++)
	{
		for(j = 0; j < (1 << MAP_SIZEY_LOG2); j++)
		{
			map_setval(map, i, j, SPACE);
		}
	}
}

void map_make_maze(_map* map, int x, int y, int difx, int dify)
{
	int i, j;
	int vx, vy;

	/* clear */
	for(i = x - difx; i <= x + difx; i++)
		for(j = y - dify; j <= y + dify; j++)
			map_setval(map, i, j, SPACE);

	map_setval(map, x, y, CORE);

	/* push initial sites */
	map->site_max = 0;

	if(rand_num_get_bit(8) < 128)
	{
		map_maze_push(map, x - 1, y);
		map_maze_push(map, x + 1, y);
	}
	else
	{
		map_maze_push(map, x, y - 1);
		map_maze_push(map, x, y + 1);
	}


	for(;;)
	{
		int dirs[4];
		int dirs_max = 0;
		/* get one */
		if(map_maze_pop(map))
			break;
		vx = map->sitex[map->site_max];
		vy = map->sitey[map->site_max];

		for(i = 0; i < 4; i++)
			dirs[i] = 0;
		if(map_maze_judge(map, x, y, difx, dify, vx + 2, vy + 0))
			dirs[dirs_max++] = 1;
		if(map_maze_judge(map, x, y, difx, dify, vx + 0, vy + 2))
			dirs[dirs_max++] = 2;
		if(map_maze_judge(map, x, y, difx, dify, vx - 2, vy + 0))
			dirs[dirs_max++] = 3;
		if(map_maze_judge(map, x, y, difx, dify, vx + 0, vy - 2))
			dirs[dirs_max++] = 4;
		if(dirs_max == 0)
			continue;	/* there are no places to go */
		i = rand_num_get() % dirs_max;
		map_maze_move_and_push(map, vx, vy, dirs[i]);
		map_maze_push(map, vx, vy);
	}
}

int map_maze_pop(_map* map)
{
	int i;
	if(map->site_max == 0)
		return 1;
	i = rand_num_get() % map->site_max;
	map->site_max--;
	if(i != map->site_max)
	{
		int tmpx = map->sitex[map->site_max];
		int tmpy = map->sitey[map->site_max];
		map->sitex[map->site_max] = map->sitex[i];
		map->sitey[map->site_max] = map->sitey[i];
		map->sitex[i] = tmpx;
		map->sitey[i] = tmpy;
	}
	return 0;
}

void map_maze_push(_map* map, int x, int y)
{
	map->sitex[map->site_max] = x;
	map->sitey[map->site_max++] = y;
	map_setval(map, x, y, WALL);
}

void map_maze_move_and_push(_map* map, int x, int y, int d)
{
	int x1 = x;
	int y1 = y;
	switch (d)
	{
	  case 1:
	  {
		x1 += 2;
		break;
	  }
	  case 2:
	  {
		y1 += 2;
		break;
	  }
	  case 3:
	  {
		x1 -= 2;
		break;
	  }
	  case 4:
	  {
		y1 -= 2;
		break;
	  }
	}
	map_maze_push(map, x1, y1);
	map_setval(map, (x + x1) / 2, (y + y1) / 2, WALL);
}

int map_maze_judge(_map* map, int cx, int cy, int dx, int dy, int x, int y)
{
	if((x < cx - dx) || (x > cx + dx) || (y < cy - dy)
			|| (y > cy + dy))
		return 0;
	if(map_getval(map, x, y) == WALL)
		return 0;
	return 1;
}

void map_convert(_map* map, unsigned int ratio)
{
	int i, j;
	int p = 0;
	for(i = 0; i < (1 << MAP_SIZEX_LOG2); i++)
	{
		for(j = 0; j < (1 << MAP_SIZEY_LOG2); j++)
		{
			p = 0;
			if(IS_SPACE(map_getval(map, i, j)))
			{
				map_clearpos(map, i, j);
				continue;
			}
			if(map_getval(map, i, j) != WALL)
				continue;
			if((j > 0) && !IS_SPACE(map_getval(map, i, j - 1)))
				p |= U_MASK;
			if((i < (1 << MAP_SIZEX_LOG2) - 1) && !IS_SPACE(map_getval(map,i + 1, j)))
				p |= R_MASK;
			if((j < (1 << MAP_SIZEY_LOG2) - 1) && !IS_SPACE(map_getval(map,i, j + 1)))
				p |= D_MASK;
			if((i > 0) && !IS_SPACE(map_getval(map, i - 1, j)))
				p |= L_MASK;
			if((p == U_MASK) || (p == R_MASK) || (p == D_MASK)
					|| (p == L_MASK))
			{
				if(rand_num_get_bit(8) < ratio)
					p |= HARD;
			}
			map_setval(map, i, j, p);
		}
	}
}


void map_clearpos(_map* map, int x, int y)
{
	//pos(x, y) = SPACE | rand_num.get(6);
	map_setval(map, x, y, SPACE | rand_num_get_bit(8));
}
