
#include "config.h"

#define SITE_MAX       1024

#define SPACE          (1<<8)
#define WALL           1
#define CORE           (1<<4)
#define U_MASK         (1<<0)
#define R_MASK         (1<<1)
#define D_MASK         (1<<2)
#define L_MASK         (1<<3)
#define HARD           (1<<5)
#define HIT_MASK       (CORE | U_MASK | R_MASK | D_MASK | L_MASK)

#define	IS_SPACE(x)	((x) & SPACE)

//#define map_setval(map, x, y, d) map->data[(((y) & (MAP_SIZEY - 1)) << MAP_SIZEX_LOG2) + (x & (MAP_SIZEX - 1))] = d
//#define map_getval(map, x, y) (map->data[(((y) & (MAP_SIZEY - 1)) << MAP_SIZEX_LOG2) + (x & (MAP_SIZEX - 1))])
//#define map_getval(map, x, y) map->data[(y << MAP_SIZEY_LOG2) + x]

#define pos(x, y) (map->data[((y) << MAP_SIZEX_LOG2) + (x)])

typedef struct {
	unsigned short data[1 << (MAP_SIZEX_LOG2 + MAP_SIZEY_LOG2)];
	int sitex[SITE_MAX];
	int sitey[SITE_MAX];
	int site_max;
} _map;

/*unsigned short map_getval(_map* map, int x, int y);
void map_setval(_map* map, int x, int y, unsigned short v);*/

void map_init(_map* map);
void map_make_maze(_map* map, int x, int y, int difx, int dify);
void map_convert(_map* map, unsigned int ratio);

unsigned short map_getval(_map* map, int x, int y);
void map_setval(_map* map, int x, int y, unsigned short d);
void map_clearpos(_map* map, int x, int y);

int map_maze_pop(_map* map);
void map_maze_push(_map* map, int x, int y);
void map_maze_move_and_push(_map* map, int x, int y, int d);
int map_maze_judge(_map* map, int cx, int cy, int dx, int dy, int x, int y);

