#include <math.h> 	//sign and cos stuff
#include "gba.h"         //GBA register definitions
#include "dispcnt.h"     //REG_DISPCNT register #defines
#include "keypad.h"      //button registers
#include "bg.h"          //background definitions
#include "sprite.h"	/* sprite stuff */
#include <stdio.h>

#include "master.pal.c"
#include "bgtiles.raw.c"

#include "sprites.pal.c"
#include "sprites.raw.c"

#include "cmap.h"
#include "scene.h"

//Rotation variables (don't worry about them here) done in later chapter
/**********************************************************************************/
FIXED angle = 0;
FIXED zoom = 1<<8;  //zoom is a fixed point number

FIXED SIN[360];	    //Look-Up Tabless for sign and cosign
FIXED COS[360];

char RotIndexCounter = 0;  //global to keep track of rotation indexes used
/**********************************************************************************/

//declare an instance of the background structure
Bg bg2;
int x_off, y_off;

// debugging output for VBA
void print(char *s)
{
    /*asm volatile("mov r0, %0;"
                 "swi 0xff;"
                 : // no ouput
                 : "r" (s)
                 : "r0");
		*/
}

//wait for the screen to stop drawing
void WaitForVsync()
{
	while((volatile u16)REG_VCOUNT != 160){}
}

u16 ship_direction = 0;

typedef struct {
	s16 x_speed, y_speed;
	u16 sprite, flip;
} ship_dir;

#define SHIP_SPEED 2

ship_dir ship_dirs[] = {
	{	0, -SHIP_SPEED, 96, 0 },
	{ SHIP_SPEED, -SHIP_SPEED, 98, 0 },
	{ SHIP_SPEED, 0, 100, 0 },
	{ SHIP_SPEED, SHIP_SPEED, 98, VERTICAL_FLIP},
	{ 0, SHIP_SPEED, 96, VERTICAL_FLIP },
	{ -SHIP_SPEED, SHIP_SPEED, 98, VERTICAL_FLIP | HORIZONTAL_FLIP },
	{ -SHIP_SPEED, 0, 100, HORIZONTAL_FLIP },
	{ -SHIP_SPEED, -SHIP_SPEED, 98, HORIZONTAL_FLIP}
};

///Test for key presses
void GetInput()
{
	int keys = *KEYS;

	if(!(keys & KEY_RIGHT))
	{
		if(!(keys & KEY_UP))
		{
			ship_direction=1;
		} else if(!(keys & KEY_DOWN)) {
			ship_direction=3;
		} else {
			ship_direction=2;
		}
	} else if(!(keys & KEY_LEFT)) {
		if(!(keys & KEY_UP))
		{
			ship_direction=7;
		} else if(!(keys & KEY_DOWN)) {
			ship_direction=5;
		} else {
			ship_direction=6;
		}
	} else if(!(keys & KEY_UP)) {
		ship_direction=0;
	} else if(!(keys & KEY_DOWN)) {
		ship_direction=4;
	}
			
	bg2.x_scroll += ship_dirs[ship_direction].x_speed;
	if(bg2.x_scroll > 8)
	{
		bg2.x_scroll -= 8;
		x_off++;
	} else if(bg2.x_scroll < -8) {
		bg2.x_scroll += 8;
		x_off--;
	}

	bg2.y_scroll += ship_dirs[ship_direction].y_speed;
	if(bg2.y_scroll > 8)
	{
		bg2.y_scroll -= 8;
		y_off++;
	} else if(bg2.y_scroll < -8) {
		bg2.y_scroll += 8;
		y_off--;
	}

	sprites[0].attribute2 = ship_dirs[ship_direction].sprite;
	sprites[0].attribute1&= ~(HORIZONTAL_FLIP | VERTICAL_FLIP);
	sprites[0].attribute1|= ship_dirs[ship_direction].flip;
	
	/*if(!(keys & KEY_L))
	{
 		angle--;
		if(angle<0)
			angle = 359;
	}
	if(!(keys & KEY_R))
	{
 		angle++;
		if(angle > 359)
			angle = 0;
	}
	if(!(keys & KEY_A))
	{
 		zoom--;
	}
	if(!(keys & KEY_B))
	{
 		zoom++;
	}*/
	
}

void fill_map(_map* map, int scene_num)
{
	_scene* s;
	int i;
	char foo[256];
	
	map_init(map);
	s = &scene[scene_num];
	sprintf(foo, "scene: %d\nbase_max: %d\n", scene_num, s->base_max);
	print("filling map\n");
	print(foo);
	
	for(i = 0; i < s->base_max; i++)
	{
		sprintf(foo, "maze: x: %d y: %d h: %d v: %d\n",
			s->base[i].x, s->base[i].y, s->base[i].h, s->base[i].v);
		print(foo);
		map_make_maze(map, s->base[i].x, s->base[i].y, s->base[i].h, s->base[i].v);
	}
	map_convert(map, s->ratio);
}

void convert_map_to_rotbg(_map* map, u16* bg, int off_x, int off_y)
{
	int segsize = 32;
	int i=0, x, y;
	unsigned short val;
	u8* scr = (u8*)VideoBuffer;
	char str[2];
	
	str[1]=0;
	
	for(y=0; y < segsize; y++)
	{
		for(x=0; x < segsize; x++)
		{
			u16 t = map_getval(map, (x + off_x), (y + off_y));
			u8 foo=0;

			if(IS_SPACE(t))
			{
				foo = t & 7;
				str[0]='s';
			} else {
				if(t < 8)
				{
					foo = 8 + (t & 7);
				} else {
					foo = 24 + ((t-8) & 7);
				}
				str[0]='w';
				
				if(t & HARD)
				{
					if(t & U_MASK)
					{
						foo = 16;
					} else if(t & R_MASK) {
						foo = 17;
					} else if(t & D_MASK) {
						foo = 18;
					} else if(t & L_MASK) {
						foo = 19;
					}
				} else if(t & CORE) {
					foo=23;
					str[0]='c';
				}
			}
			//print(str);
			//scr[y * 240 + x] = foo;
			//fputc(foo, stdout);
			//bg[i++] = foo;
			if((x % 2) == 0)
			{
				val = foo;
			} else {
				val |= (foo << 8);
				bg[i++] = val;
			}
		}
		//fputc('\n', stdout);
		str[0]='\n';
		//print(str);
	}
}

///main entry point from the boot.asm startup file
int AgbMain()
{
	_map map;

	u16 loop;
	u16* temp;      //temporary storage pointer
	
	//interrupt_init();
	
	//compute my Look up tables (Rotation stuff again)
	for(loop = 0; loop < 360; loop++)
	{
		//SIN[loop] = (FIXED)(gba_sin(loop) * 2);  //sin and cos are computed and cast to fixed							//fixed
		SIN[loop] = 0; COS[loop]=256;
		//COS[loop] = (FIXED)(gba_cos(loop) * 2);
	}

	//set mode 2 and enable sprites and 1d mapping
	SetMode(MODE_2 | BG2_ENABLE | OBJ_ENABLE | OBJ_MAP_1D);

	//Let us set up the backgroud two structure and enable the background

	bg2.number = 2;				//background number 0-3
	bg2.charBaseBlock = 0;                  //tile data position (right at the start of the available memory on 16Kb boundary)
	bg2.screenBaseBlock = 28;		//map data position on 2Kb boundary
	bg2.colorMode = BG_COLOR_256;           //256-colour background
	bg2.size = ROTBG_SIZE_256x256;          //size of map
	//bg2.size = TEXTBG_SIZE_256x256;
	bg2.mosaic = 0;                         //not enabled
	bg2.x_scroll = 0;			//scrolling variables
	bg2.y_scroll = 0;

	//Point to correct tile and map data, update the Background and Display registers accordingly
	EnableBackground(&bg2);

	for(loop = 0; loop < 256; loop++)
		BGPaletteMem[loop] = master_Palette[loop];     //load the background palette into memory

	temp = (u16*)bgtiles_Bitmap;
	
	for(loop = 0; loop < bg_numtiles * 32; loop++)  //load tile image data
		bg2.tileData[loop] = temp[loop];

	/* load sprite palette and tile data */
	for(loop = 0; loop < 256; loop++)
	{
		OBJPaletteMem[loop] = sprites_Palette[loop];
	}
	
	InitialiseSprites();
	temp = (u16*) sprites_Bitmap;
	for(loop = 0; loop < (6 * 16) * 32; loop++)
	{
		OAMData[loop] = temp[loop];
	}
	
	sprites[0].attribute0 = COLOR_256 | SQUARE | 80;
	sprites[0].attribute1 = SIZE_8 | 120;
	sprites[0].attribute2 = 96;
	
	fill_map(&map, 0);
	convert_map_to_rotbg(&map, bg2.mapData, 0, 0);
	
	//while(0 == 0);
	
	//Main Game loop
	while(1)
	{
		GetInput();    //check for input
		RotateBackground(&bg2,angle,0,0,zoom); 	//rotates background if required (don't worry about this)
		UpdateBackground(&bg2); //make sure registers are updated if anything changes e.g. scrolling
		convert_map_to_rotbg(&map, bg2.mapData, x_off, y_off);
		CopyOAM();
		gba_vsync();
	}
	return(0);
}
