#include "main.h"

/* create the map */

#define MAP_SIZE_X 16
#define MAP_SIZE_Y 8

u8 map[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1,
	1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

s32 px = (64 * 4);
s32 py = (64 * 4);
s32 pa = 0;

#define SCREEN_WIDTH 120
#define SCREEN_HEIGHT 160

//u8 scanline_buffer[2 * SCREEN_HEIGHT];

#define PROJECTION_DISTANCE 208
//#define PROJECTION_DISTANCE 104

/*SDL_Color palette[] = {
	{ 0, 0, 0, 0},
	{ 50, 50, 50, 0},
	{ 100, 100, 100, 0},
	{ 200, 200, 200, 0},
	{ 0, 0, 200, 0}
};*/

/*int pythag(float dx, float dy)
{
	return sqrt(dx*dx + dy*dy);
}*/

/*double gettimeofday_double()
{
	struct timeval tv;
	double foo;
	gettimeofday(&tv, NULL);
	
	foo = tv.tv_usec; foo/= 1000000.0;
	foo+= tv.tv_sec;
	return foo;
}*/

#define MOVE_UP		1 << 0
#define MOVE_DOWN	1 << 1
#define MOVE_SL		1 << 2
#define MOVE_SR		1 << 3
#define MOVE_TL		1 << 4
#define MOVE_TR		1 << 5

#include "bricks.raw.c"
#include "bricks.pal.c"

//#define TRACE(x...) printf(x)
#define TRACE(x...)

#include "table.h"

#define FIXED(x) ((int)((x) * 256))
#define FIXED_TO_INT(x) ((x)  >> 8)

// debugging output for VBA
void print(char *s)
{
    asm volatile("mov r0, %0;"
                 "swi 0xff;"
                 : // no ouput
                 : "r" (s)
                 : "r0");
		
}


s32 gba_sin(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[angle >> 6];
		} else {
			res = sin_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = -sin_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -sin_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res >> 8);
}

s32 gba_cos(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[(FIXED(90) - angle) >> 6];
		} else {
			res = -sin_table[(angle - FIXED(90)) >> 6];
		}
	} else {
		if(angle < FIXED(270))
		{
			res = -sin_table[(FIXED(270) - angle) >> 6];
		} else {
			res = sin_table[(angle - FIXED(270)) >> 6];
		}
	}
	
	return(res >> 8);
}

s32 gba_tan(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = tan_table[angle >> 6];
		} else {
			res = -tan_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = tan_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -tan_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res >> 8);
}

void asm_rasterise_line(u32 x, s32 slice_height, const u8* tex, u32 texture_offset,
	u32 tex_inc_low, u32 tex_inc_high) CODE_IN_IWRAM;

#define USE_ASM_RASTER

#ifdef USE_ASM_RASTER
void rasterise_line(u32 x, s32 slice_height, u32 texture_offset)
{
	int tex_inc_high, tex_inc_low;
	
	tex_inc_high = 64 / slice_height;
	tex_inc_low = (((64 % slice_height) << 16) / slice_height);

	asm_rasterise_line(x, slice_height, bricks_Bitmap, texture_offset, tex_inc_low, tex_inc_high);
}

#else
void rasterise_line(u32 x, s32 slice_height, u32 texture_offset)
{
	int y;
	u16* scr = (u16*)VideoBuffer + x;
	int wall_start_y, wall_end_y;
	int tex_pos=0, tex_low=0;
	int tex_inc_high, tex_inc_low;
	
	wall_start_y = (SCREEN_HEIGHT - slice_height)/2;
	wall_end_y = (SCREEN_HEIGHT + slice_height)/2;

	tex_inc_high = 64 / slice_height;
	tex_inc_low = (((64 % slice_height) << 16) / slice_height);
	
	for(y=0; y < wall_start_y; y++)
	{
		scr[y * SCREEN_WIDTH] = 5 | 5 << 8;
	}

	if(slice_height > SCREEN_HEIGHT)
	{
		//tex_pos = (-wall_start_y) * 64 / slice_height;
		tex_low = (-wall_start_y) * tex_inc_low;
		tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);
		tex_low &= 0x0000ffff;

		wall_start_y = 0; wall_end_y = SCREEN_HEIGHT;
	}

	for(y = wall_start_y; y < wall_end_y ; y++)
	{
		//int y_pos = y + ((SCREEN_HEIGHT - slice_height) / 2);
		if(y >= 0 && y < SCREEN_HEIGHT)
		{
			u16 pix = wall_Bitmap[(tex_pos * 64) + texture_offset];
			scr[y * SCREEN_WIDTH] = pix | pix << 8;
		}
		
		tex_low += tex_inc_low;
		if(tex_low > (1 << 16))
		{
			tex_low -= (1 << 16);
			tex_pos++;
		}
		tex_pos += tex_inc_high;
		
	}

	for(y=wall_end_y; y <SCREEN_HEIGHT; y++)
	{
		scr[y * SCREEN_WIDTH] = 5 | 5 << 8;
	}
}
#endif
void raycast()
{
	int i;
	
	/* scan across the screen */
	for(i=0; i < SCREEN_WIDTH; i++)
	{
		s32 angle = FIXED(pa) + (i * (FIXED(60)/SCREEN_WIDTH)) - FIXED(30);
		int Xa, Ya;
		int ax, ay;
		int cur_x, cur_y;
		int grid_x, grid_y;
		int wall_hit_x, wall_hit_y;
		int distance;
		int d1, d2;

		int slice_height;
		int texture_offset; 
		
		if(angle < FIXED(0)) angle += FIXED(360);
		if(angle > FIXED(360)) angle -= FIXED(360);
		
		TRACE("checking ray %d, angle %f\n", i, angle / 256.0);
		
		/* trace horizontal ray/grid intersections */
		
		/* if ray is facing upwards */
		if(angle < FIXED(180))
		{
			/* get vertical co-ord of first grid intersection */
			ay = (py / 64) * (64) - 1;
			
			/* Ya points up */
			Ya = -64;
		} else {
			/* get vertical co-ord of first grid intersection */
			ay = (py / 64) * (64) + 64;

			/* Ya points down */
			Ya = 64;
		}
		
		/* now get horiz co-ord of first grid intersection */
		if(gba_tan(angle))
		{
			ax = px + ((py - ay) << 8) / gba_tan(angle);

			/* calculate X increment between intersections */
			Xa = (-Ya << 8) / gba_tan(angle);
		} else {
			ax = 1 << 16; Xa = 1 << 16;
		}
		
		/* loop until we hit a wall */
		cur_x = ax; cur_y = ay;

		TRACE("Tracing horizontally...\n");
		TRACE("Starting at %d/%d, inc by %d/%d\n", ax, ay, Xa, Ya);

		while(1)
		{
			grid_x = cur_x / 64;
			grid_y = cur_y / 64;

			if(grid_x < 0 || grid_x > MAP_SIZE_X || grid_y < 0 || grid_y > MAP_SIZE_Y)
				break;

			TRACE("Looking at %d/%d (%d/%d) for wall\n", cur_x, cur_y, grid_x, grid_y);
			
			if(map[grid_x + (grid_y * MAP_SIZE_X)])
			{
				break;
			}
			cur_x += Xa;
			cur_y += Ya;
		}
		TRACE("wall found!\n");
		wall_hit_x = cur_x; wall_hit_y = cur_y;
		if(abs(px - cur_x) > abs(py - cur_y))
		{
			d1 = abs(((px - cur_x) << 8) / gba_cos(angle));
		} else {
			d1 = abs(((py - cur_y) << 8) / gba_sin(angle));
		}
		//d1 = pythag(px - cur_x, py - cur_y);
		
		/* trace vertically */

		/* if ray is facing right */
		if(angle > FIXED(90) && angle < FIXED(270))
		{
			/* get vertical co-ord of first grid intersection */
			ax = (px / 64) * (64) - 1;
			
			/* Xa points right */
			Xa = -64;
		} else {
			ax = (px / 64) * (64) + 64;
			
			/* Xa points left */
			Xa = 64;
		}
		
		/* now get horiz co-ord of first grid intersection */
		ay = py + (((px - ax)*gba_tan(angle)) >> 8);

		/* calculate X increment between intersections */
		Ya = ((-Xa) * gba_tan(angle)) >> 8;

		/* loop until we hit a wall */
		cur_x = ax; cur_y = ay;

		TRACE("Tracing vertically...\n");
		TRACE("Starting at %d/%d, inc by %d/%d\n", ax, ay, Xa, Ya);
		
		while(1)
		{
			grid_x = cur_x / 64;
			grid_y = cur_y / 64;

			if(grid_x < 0 || grid_x >= MAP_SIZE_X || grid_y < 0 || grid_y >= MAP_SIZE_Y)
				break;
			
			TRACE("Looking at %d/%d (%d/%d) for wall\n", cur_x, cur_y, grid_x, grid_y);
			
			if(map[grid_x + (grid_y * MAP_SIZE_X)])
			{
				break;
			}
			cur_x += Xa;
			cur_y += Ya;
		}
		TRACE("wall found!\n");

		/* check which of the horizontal trace or the vertical trace found the
		 * nearer wall */
		if(abs(px - cur_x) > abs(py - cur_y))
		{
			d2 = abs(((px - cur_x) << 8) / gba_cos(angle));
		} else {
			d2 = abs(((py - cur_y) << 8)/ gba_sin(angle));
		}
		//d2 = pythag(px - cur_x, py - cur_y);
		
		if(d2 < d1)
		{
			wall_hit_x = cur_x; wall_hit_y = cur_y;
			texture_offset = wall_hit_y % 64;
			distance = d2;
		} else {
			texture_offset = wall_hit_x % 64;
			distance = d1;
		}
		TRACE("Nearest wall hit at %d/%d\n", wall_hit_x, wall_hit_y);

		//distance = pythag(py - wall_hit_y, px - wall_hit_x);

		TRACE("distance: %d ", distance);
		TRACE("beta: %f ", (FIXED(pa) - angle) / 256.0);
		distance = (distance * gba_cos(abs((FIXED(pa) - angle))));

		TRACE("adjusted distance: %d\n", distance);

		slice_height = FIXED(64 * PROJECTION_DISTANCE)  / distance;
		
		/* draw here! */
		rasterise_line(i, slice_height, texture_offset);
	}
}

void player_move(s32 angle)
{
	s32 foo;
	s32 speed = 10;

#define WALL_OFFSET 10
#define MAP_COORD(x, y) ((((y) >> 6) * MAP_SIZE_X) + ((x) >> 6))		

	foo = px + (((speed + WALL_OFFSET) * gba_cos(angle)) >> 8);
	if(map[MAP_COORD(foo, py)] == 0)
		px = px + (((speed) * gba_cos(angle)) >> 8);
	
	foo = py - (((speed + WALL_OFFSET) * gba_sin(angle)) >> 8);
	if(map[MAP_COORD(px, foo)] == 0)
		py = py - (((speed) * gba_sin(angle)) >> 8);
}

int AgbMain()
{
	int i;
	char foo[100];
	
	//double curtime, lasttime;
	//int framewait = 0;
	u32 movement = 0;

	//trigtest();
	SetMode(MODE_4 | BG2_ENABLE);
	for(i=0; i < 256; i++)
		BGPaletteMem[i] = bricks_Palette[i];
	
	gba_initbank();

	//lasttime = gettimeofday_double();
	
	while(1)
	{
		u32 keys = *KEYS;
		
		movement = 0;
		
		if(!(keys & KEY_UP)) movement |= MOVE_UP;
		if(!(keys & KEY_DOWN)) movement |= MOVE_DOWN;
		if(!(keys & KEY_LEFT)) movement |= MOVE_TL;
		if(!(keys & KEY_RIGHT)) movement |= MOVE_TR;
		if(!(keys & KEY_L)) movement |= MOVE_SL;
		if(!(keys & KEY_R)) movement |= MOVE_SR;

		/* handle motion */
		if(movement & MOVE_TL)
		{
			pa -= 5;
		}
		if(movement & MOVE_TR)
		{
			pa += 5;
		}
		if(pa < 0) pa += 360;
		if(pa > 360) pa -= 360;

		/*sprintf(foo, "px: %4d py: %4d gx: %3d gy: %3d\n", px, py, px >> 6, py >> 6);
		print(foo);*/

		if(movement & MOVE_UP)
		{
			player_move(FIXED(pa));
		}
				
		if(movement & MOVE_DOWN)
		{
			s32 angle = pa + 180;
			if(angle > 360) angle -= 360;
			player_move(FIXED(angle));
		}
				
		if(movement & MOVE_SL)
		{
			s32 angle = pa - 90;
			if(angle < 0) angle += 360;
			player_move(FIXED(angle));
		}

		if(movement & MOVE_SR)
		{
			s32 angle = pa + 90;
			if(angle > 360) angle -= 360;
			player_move(FIXED(angle));
		}
		
		raycast();
		gba_vsync();
		gba_swapbank();

		/*framewait++;
		
		if(framewait == 10)
		{
			curtime = gettimeofday_double();
			fprintf(stderr, "FPS: %f\r", 10.0 / (curtime - lasttime));
			fflush(stderr);
			lasttime = curtime;
			framewait = 0;
		}*/
		//usleep(100000);
	}

	return 0;
}
