#include "main.h"

texobject objs[] = {
	{ 400, 100, 0}
};

const int num_objs = 1;

void objs_draw(s32 px, s32 py, s32 angle)
{
	int i;
	char foo[100];
	
	for(i=0; i < num_objs; i++)
	{
		texobject* o = &objs[i];
		float o_angle;
		int dist;
		
		o_angle = atan(((py - o->y)*1.0) / (px - o->x)) * 256 / (M_PI/180.0);
		if(o_angle < 0) o_angle += 360 * 256;
		
		if(o_angle > FIXED(angle - 30) && o_angle < FIXED(angle + 30))
		{
			int i;
			u16* scr = VideoBuffer;
			
			for(i=0; i < 160; i++)
			{
				scr[i*120 + (int)(((angle + 30) - (o_angle / 256) * 2))] = 0;
			}
			print("object visible!\n");
		
			if(abs(px - o->x) > abs(py - o->y))
			{
				dist = abs(((px - o->x) << 8) / gba_cos(o_angle));
			} else {
				dist = abs(((py - o->y) << 8) / gba_sin(o_angle));
			}
			dist = pythag(px - o->x, py - o->y);
		
			sprintf(foo, "obj: angle: %f dist: %d\n", o_angle/256, dist); print(foo);
		}
	
	}
}

