
	.global	asm_rasterise_line
	.global	asm_rasterise_obj_line
	
	.extern	gba_bank

	.section	.iwram,"ax",%progbits
	.arm
	.align
	.text

@ void asm_rasterise_line(u32 x, s32 slice_height, u8* tex, u32 texture_offset)
@                            r0      r1      				r2      r3 
asm_rasterise_line:
	mov ip, sp

	stmfd	sp!,{r4-r11}
	
	@ calculate tex_inc_low and tex_inc_high
	stmfd	sp!,{r0-r3}
	mov r7, r1
	mov r0, #64
	swi	#0x060000 @ tex_inc_high = 64 / slice_height;
	mov	r5, r0
	mov	r0, r1, lsl #16
	mov	r1, r7
	swi	#0x060000 @ tex_inc_low = (((64 % slice_height) << 16) / slice_height);
	mov	r4, r0
	ldmfd	sp!,{r0-r3}
	

	@ calculate starting position
	mov	r0, r0, lsl #1
	ldr	r6, =gba_bank
	ldr	r7, [r6]
	ldr	r6, [r6, r7, lsl #2]
	add r0, r0, r6

	@ calculate wall_start_y and wall_end_y
	mov	r6, #160/2
	sub	r6, r6, r1, asr #1
	add	r7, r6, r1
	
	@ set tex_pos and tex_low_pos to 0
	mov	r8, #0
	mov	r9, #0
	
	@ offset texture by texture offset
	add	r2, r2, r3

	@ if wall_start_y < 0, clip wall_start_y and wall_end_y to screen boundary
	cmp	r6, #0
	bge	1f

	@ clip wall_start_y and wall_end_y to screen boundary
	@ fix up tex_pos first
	rsb	r6, r6, #0
	mul	r9, r6, r4	@ tex_low = (-wall_start_y) * tex_inc_low;
	mul	r8, r6, r5
	add	r8, r8, r9, lsr #16 @ tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);
	@add	r2, r2, r8, lsl #6 @ add tex_pos to tex*

	mov	r9, r9, lsl #16
	@mov r9, r9, lsr #16
	
	@ and clip wall_(start|end)_y
	mov	r6, #0
	mov	r7, #160

1:
	@ fill floor and ceiling
	cmp r6, #0
	beq	3f		 @ skip floor filling if gap is 0

	@b 3f

	@ we're actually filling both floor and ceiling in one, so
	@ get offset from floor to ceiling
	
	add	r10, r1, r6
	mov	r3, r10, lsl #8
	sub	r3, r3, r10, lsl #4
	
	mov	r10, r6
	mov	r11, #9
	add	r11, r11, r11, lsl #8

2:
	strh	r11, [r0]
	strh	r11, [r0, r3]
	add		r0, r0, #240

	subs	r10, r10, #1
	bgt		2b

3:
	@ draw wall

	sub	r10, r7, r6 @ number of pixels to fill is wall_end_y - wall_start_y

	@ scale tex_inc_low up for carry checking
	mov r4, r4, lsl #16
	
2:
	ldrb	r11, [r2, r8, lsl #6]
	strb	r11, [r0]
	
	add		r0, r0, #240

	@ adjust tex_pos and tex_low
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	subs	r10, r10, #1
	bgt		2b

4:

	@ all done!
	ldmfd	sp!,{r4-r11}
	bx lr

@ void asm_rasterise_obj_line(u32 x, s32 slice_height, u8* tex, u32 texture_offset, u32 tex_inc_low, u32 tex_inc_high )
@                            r0      r1      				r2      r3                       r4                r5
asm_rasterise_obj_line:
	mov ip, sp

	stmfd	sp!,{r4-r11}
	ldmfd	ip, {r4-r5}

	@ calculate starting position
	mov	r0, r0, lsl #1
	ldr	r6, =gba_bank
	ldr	r7, [r6]
	ldr	r6, [r6, r7, lsl #2]
	add r0, r0, r6

	@ calculate wall_start_y and wall_end_y
	mov	r6, #160/2
	sub	r6, r6, r1, asr #1
	add	r7, r6, r1
	
	@ set tex_pos and tex_low_pos to 0
	mov	r8, #0
	mov	r9, #0
	
	@ offset texture by texture offset
	add	r2, r2, r3

	@ if wall_start_y < 0, clip wall_start_y and wall_end_y to screen boundary
	cmp	r6, #0
	bge	1f

	@ clip wall_start_y and wall_end_y to screen boundary
	@ fix up tex_pos first
	rsb	r6, r6, #0
	mul	r9, r6, r4	@ tex_low = (-wall_start_y) * tex_inc_low;
	mul	r8, r6, r5
	add	r8, r8, r9, lsr #16 @ tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);

	mov	r9, r9, lsl #16
	
	@ and clip wall_(start|end)_y
	mov	r6, #0
	mov	r7, #160

	@ draw object
1:
	@ offset draw location by the appropriate number of scanlines
	mov	r10, r6, lsl #8
	sub	r10, r10, r6, lsl #4
	add	r0, r0, r10

	sub	r10, r7, r6 @ number of pixels to fill is wall_end_y - wall_start_y

	@ scale tex_inc_low up for carry checking
	mov r4, r4, lsl #16
	
2:
	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	strneb	r11, [r0]
	
	add		r0, r0, #240

	@ adjust tex_pos and tex_low
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	subs	r10, r10, #1
	bgt		2b

4:

	@ all done!
	ldmfd	sp!,{r4-r11}
	bx lr
