#include "gba.h"

extern u32 seconds;

void (*IntrTable[14])(void);

void interrupt_dummy(void) {
};

void interrupt_key(void) {
  asm volatile ("\n\
      mov	a1, #0x8c	@ Point at BIOS hard reset.\n\
      bx	a1		@ Go."
  );
}

void interrupt_timer2(void)
{
	seconds++;
}

void interrupt_init(void) {
  int i;

  // Set all interrupts to dummy functions.
  for(i = 0; i < 14; i ++) IntrTable[i] = (void (*)(void))interrupt_dummy;

  // Set selected interrupts to do something fun/useful.
  IntrTable[12] = (void (*)(void))interrupt_key;
	IntrTable[5] = (void (*)(void))interrupt_timer2;
	//IntrTable[4] =  (void (*)(void))interrupt_sound;
}
