#include "main.h"

#include "sprites.raw.c"

extern u32 seconds;


/* FIXME: objects currently aren't depth sorted. This needs to be fixed :) */

texobject objs[] = {
	{ 400, 100, sprites_Bitmap},
	{ 400, 800, sprites_Bitmap},
	{ 350, 850, sprites_Bitmap},
	{ 300, 900, sprites_Bitmap},
	{ 1400, 1600, sprites_Bitmap},
	{ 1450, 1600, sprites_Bitmap},
	{ 1200, 1660, sprites_Bitmap},
	{ 1300, 1700, sprites_Bitmap},
	{ 1110, 1700, sprites_Bitmap},
	{ 1300, 1650, sprites_Bitmap},
};

const int num_objs = 10;

void asm_rasterise_obj_line(u32 x, s32 slice_height, const u8* tex, u32 texture_offset, u32 tex_inc_low, u32 tex_inc_high) CODE_IN_IWRAM;

void objs_draw(s32 px, s32 py, s32 angle, s32* dist_buf)
{
	int i;
	char foo[100];
	
	for(i=0; i < num_objs; i++)
	{
		texobject* o = &objs[i];
		s32 o_angle;
		int dist, obj_pa_angle;
		s32 slice_height, slice_width;
		s32 width_angle;
		int stime, etime;
		
		o_angle = gba_atan(py - o->y, o->x - px);
		
		obj_pa_angle = (angle - 30);
		if(obj_pa_angle < 0) obj_pa_angle += 360;
		obj_pa_angle = ((o_angle / 256) - obj_pa_angle);
		if(obj_pa_angle < 0) obj_pa_angle += 360;	
		
		if(abs(px - o->x) > abs(py - o->y))
		{
			dist = abs(((px - o->x) << 8) / gba_cos(o_angle));
		} else {
			dist = abs(((py - o->y) << 8) / gba_sin(o_angle));
		}
		
		dist = (dist * gba_cos(abs(FIXED(obj_pa_angle - 30))));
		slice_height = FIXED(64 * PROJECTION_DISTANCE)  / dist;
		/* clip slice_height to prevent silly things happening */
		if(slice_height > SCREEN_HEIGHT*4) slice_height = SCREEN_HEIGHT*4;
		slice_width = slice_height / 2;

		//sprintf(foo, "obj: angle: %d pa: %d o-pa: %d dist: %d height: %d\n", o_angle/256, angle, obj_pa_angle, FIXED_TO_INT(dist), slice_height); print(foo);
		
		width_angle = slice_width / 4;
		if(obj_pa_angle + width_angle > 0 && obj_pa_angle - width_angle < 60)
		{
			//print("object visible!\n");

			/* draw the object */
			int x;
			int x_offset = ((obj_pa_angle) * SCREEN_WIDTH / 60) - (slice_width/2);
			int tex_pos=0, tex_low=0;
			int tex_inc_high, tex_inc_low;
			int y_tex_inc_high, y_tex_inc_low;
			
			s32 start_x, end_x;
	
			tex_inc_high = 64 / slice_width;
			tex_inc_low = (((64 % slice_width) << 16) / slice_width);
			
			y_tex_inc_high = 64 / slice_height;
			y_tex_inc_low = (((64 % slice_height) << 16) / slice_height);
					
			start_x = x_offset; end_x = x_offset + slice_width;

			if(start_x < 0)
			{
				tex_low = (-start_x) * tex_inc_low;
				tex_pos = (-start_x) * tex_inc_high + (tex_low >> 16);
				tex_low &= 0x0000ffff;

				start_x = 0;
			}
			if(end_x > SCREEN_WIDTH)
			{
				end_x = SCREEN_WIDTH;
			}
			
			/* if this sprite's left and right sides are both hidden, don't draw it
			 * at all */
			//sprintf(foo, "drawing object %d : sx: %d ex: %d\n", i, start_x, end_x); print(foo);
			stime = seconds;
			for(x=start_x; x < end_x; x++)
			{
				if(FIXED_TO_INT(dist) < dist_buf[x])
				{
					asm_rasterise_obj_line(x, slice_height, o->tex, tex_pos,
						y_tex_inc_low, y_tex_inc_high);
				}
				tex_low += tex_inc_low;
				if(tex_low > (1 << 16))
				{
					tex_low -= (1 << 16);
					tex_pos++;
				}
				tex_pos += tex_inc_high;
			}
			etime = seconds;
			//sprintf(foo, "raster time: %d\n", etime - stime); print(foo);
		}
	}
}

