#include "gba.h"
#include "table.h"

#define FIXED(x) ((int)((x) * 256))

s32 gba_sin(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[angle >> 6];
		} else {
			res = sin_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = -sin_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -sin_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res >> 8);
}

s32 gba_cos(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[(FIXED(90) - angle) >> 6];
		} else {
			res = -sin_table[(angle - FIXED(90)) >> 6];
		}
	} else {
		if(angle < FIXED(270))
		{
			res = -sin_table[(FIXED(270) - angle) >> 6];
		} else {
			res = sin_table[(angle - FIXED(270)) >> 6];
		}
	}
	
	return(res >> 8);
}

s32 gba_tan(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle <= FIXED(90))
		{
			res = tan_table[angle >> 6];
		} else {
			res = -tan_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = tan_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -tan_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res >> 8);
}

s32 gba_atan(s32 y, s32 x)
{
	s32 tanval;
	s32 angle;

	if(x == 0)
	{
		angle = 90 * 4;
	} else if(y == 0) {
		angle = 0;
	} else {
		tanval = abs((y << 16) / x);
		angle = 0;

		while(angle < (90*4)+1)
		{
			if(tan_table[angle] > tanval) break;
			angle++;
		}
	}
	angle = angle * 64;
	
	/* move angle to appropriate quadrant */
	if(x < 0)
	{
		if(y > 0)
		{
			angle = FIXED(180) - angle;
		} else {
			angle = FIXED(180) + angle;
		}
	} else {
		if(y < 0)
		{
			angle = FIXED(360) - angle;
		}
	}

	return angle;
}
