
#include "config.h"

	.global	asm_rasterise_line
	.global	asm_fpsmeter
	.global	asm_rasterise_obj_line
	.global	asm_floor_draw
	.extern	gba_bank
	.extern	floor_dist_table
	.extern	map
	.extern	paltable

	.section	.iwram,"ax",%progbits
	.arm
	.align
	.text

@ void asm_rasterise_line(u32 x, s32 slice_height, u8* tex, u32 texture_offset)
@                            r0      r1      				r2      r3 
asm_rasterise_line:
	mov ip, sp

	stmfd	sp!,{r4-r11}
	ldmfd	ip, {r4-r6}
	
	mov	r11, r6
	@ calculate tex_inc_low and tex_inc_high
	@stmfd	sp!,{r0-r3}
	@mov r7, r1
	@mov r0, #64
	@swi	#0x060000 @ tex_inc_high = 64 / slice_height;
	@mov	r5, r0
	@mov	r0, r1, lsl #16
	@mov	r1, r7
	@swi	#0x060000 @ tex_inc_low = (((64 % slice_height) << 16) / slice_height);
	@mov	r4, r0
	@ldmfd	sp!,{r0-r3}

	@ calculate starting position
	mov	r0, r0, lsl #1
	ldr	r6, =gba_bank
	ldr	r7, [r6]
	ldr	r6, [r6, r7, lsl #2]
	add r0, r0, r6

	@ calculate wall_start_y and wall_end_y
	mov	r6, #SCREEN_HEIGHT/2
	sub	r6, r6, r1, asr #1
	add	r7, r6, r1
	
	@ set tex_pos and tex_low_pos to 0
	mov	r8, #0
	mov	r9, #0
	
	@ offset texture by texture offset
	add	r2, r2, r3

	@ if wall_start_y < 0, clip wall_start_y and wall_end_y to screen boundary
	cmp	r6, #0
	bge	1f

	@ clip wall_start_y and wall_end_y to screen boundary
	@ fix up tex_pos first
	rsb	r6, r6, #0
	mul	r9, r6, r4	@ tex_low = (-wall_start_y) * tex_inc_low;
	mul	r8, r6, r5
	add	r8, r8, r9, lsr #16 @ tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);

	mov	r9, r9, lsl #16
	
	@ and clip wall_(start|end)_y
	mov	r6, #0
	mov	r7, #SCREEN_HEIGHT


1:
	mov	r3, r11
	
	@ fill floor and ceiling
	cmp r6, #0
	beq	3f		 @ skip floor filling if gap is 0

	mov	r10, r6
	mov	r11, #9
	add	r11, r11, r11, lsl #8

2:
	strh	r11, [r0], #SCREEN_PITCH
	subs	r10, r10, #1
	bgt		2b

3:
	@ draw wall

	sub	r10, r7, r6 @ number of pixels to fill is wall_end_y - wall_start_y

	@ scale tex_inc_low up for carry checking
	mov r4, r4, lsl #16

	@ 4x unrolled loop below
	@movs	r1, r10, lsr #2
	@beq		3f

	b		3f

	sub		r10, r10, r1, lsl #2
2:
	ldrb	r11, [r2, r8, lsl #6]
	adds	r9, r9, r4
	strb	r11, [r0], #SCREEN_PITCH
	adc		r8, r8, r5

	ldrb	r11, [r2, r8, lsl #6]
	adds	r9, r9, r4
	strb	r11, [r0], #SCREEN_PITCH
	adc		r8, r8, r5

	ldrb	r11, [r2, r8, lsl #6]
	adds	r9, r9, r4
	strb	r11, [r0], #SCREEN_PITCH
	adc		r8, r8, r5

	ldrb	r11, [r2, r8, lsl #6]
	adds	r9, r9, r4
	strb	r11, [r0], #SCREEN_PITCH
	adc		r8, r8, r5

	subs	r1, r1, #1
	bgt		2b

3:
	ldrb	r11, [r2, r8, lsl #6]
	ldrb	r11, [r3, r11]
	strb	r11, [r0], #SCREEN_PITCH
	
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	subs	r10, r10, #1
	bgt		3b

4:

	@ all done!
	ldmfd	sp!,{r4-r11}
	bx lr

@ void asm_rasterise_obj_line(u32 x, s32 slice_height, u8* tex, u32 texture_offset, u32 tex_inc_low, u32 tex_inc_high )
@                            r0      r1      				r2      r3                       r4                r5
asm_rasterise_obj_line:
	mov ip, sp

	stmfd	sp!,{r4-r11}
	ldmfd	ip, {r4-r6}
	
	mov		r11, r6
	
	@ calculate starting position
	mov	r0, r0, lsl #1
	ldr	r6, =gba_bank
	ldr	r7, [r6]
	ldr	r6, [r6, r7, lsl #2]
	add r0, r0, r6

	@ calculate wall_start_y and wall_end_y
	mov	r6, #SCREEN_HEIGHT/2
	sub	r6, r6, r1, asr #1
	add	r7, r6, r1
	
	@ set tex_pos and tex_low_pos to 0
	mov	r8, #0
	mov	r9, #0
	
	@ offset texture by texture offset
	add	r2, r2, r3

	@ if wall_start_y < 0, clip wall_start_y and wall_end_y to screen boundary
	cmp	r6, #0
	bge	1f

	@ clip wall_start_y and wall_end_y to screen boundary
	@ fix up tex_pos first
	rsb	r6, r6, #0
	mul	r9, r6, r4	@ tex_low = (-wall_start_y) * tex_inc_low;
	mul	r8, r6, r5
	add	r8, r8, r9, lsr #16 @ tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);

	mov	r9, r9, lsl #16
	
	@ and clip wall_(start|end)_y
	mov	r6, #0
	mov	r7, #SCREEN_HEIGHT

	@ draw object
1:
	@ offset draw location by the appropriate number of scanlines
	mov	r10, r6, lsl #8
	sub	r10, r10, r6, lsl #4
	add	r0, r0, r10

	sub	r10, r7, r6 @ number of pixels to fill is wall_end_y - wall_start_y

	@ scale tex_inc_low up for carry checking
	mov r4, r4, lsl #16

	mov	r3, r11

	@ 4x unrolled loop below
	@movs	r1, r10, lsr #2
	@beq		3f
	
	@sub		r10, r10, r1, lsl #2
	
	b 3f
2:
	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	strneb	r11, [r0]
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	strneb	r11, [r0, #SCREEN_PITCH]
	adds	r9, r9, r4
	adc		r8, r8, r5

	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	strneb	r11, [r0, #SCREEN_PITCH*2]
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	strneb	r11, [r0, #SCREEN_PITCH*3]
	adds	r9, r9, r4
	adc		r8, r8, r5
	
	add		r0, r0, #SCREEN_PITCH*4
	subs	r1, r1, #1
	bgt		2b

3:
	ldrb	r11, [r2, r8, lsl #6]
	cmp		r11, #0
	ldrneb	r11, [r3, r11]
	strneb	r11, [r0]
	adds	r9, r9, r4
	adc		r8, r8, r5

	add		r0, r0, #SCREEN_PITCH
	subs	r10, r10, #1
	bgt		3b
	
	@ all done!
	ldmfd	sp!,{r4-r11}
	bx lr


asm_fpsmeter:
	stmfd		sp!, {r4-r5}
	
	ldr	r1, =gba_bank
	ldr	r2, [r1]
	ldr	r1, [r1, r2, lsl #2]
	mov	r3, #SCREEN_HEIGHT-2
	mov	r5,	#SCREEN_PITCH
	mul	r4, r3, r5
	add	r1, r1, r4
	mov	r3, #0

1:
	strh	r3, [r1]
	strh	r3, [r1, #SCREEN_PITCH]
	
	add		r1, r1, #2
	subs	r0, r0, #1
	bge		1b

	ldmfd	sp!, {r4-r5}
	bx lr


@ void asm_floor_draw(u32 x, s32 slice_height, u8* tex, s32 cos_a, s32 sin_a, s32 one_over_cos_b, s32 px, s32 py)
@                            r0      r1      				r2      r3         r4     r5          r6                r7
asm_floor_draw:
	mov ip, sp

	stmfd	sp!,{r4-r11}
	ldmfd	ip, {r4-r7}
	
	@ chuck cos_a, sin_a and one_over_cos_b onto the stack
	sub		sp, sp, #24
	
	str		r3, [sp, #0]
	str		r4, [sp, #4]
	str		r5, [sp, #8]
	
	ldr		r4, =map
	ldr		r4, [r4]
	str		r4, [sp, #12]
	
	ldr		r4, =paltable
	@ldr		r4, [r4]
	str		r4, [sp, #16]

	@ calculate starting position
	mov	r0, r0, lsl #1
	ldr	r8, =gba_bank
	ldr	r9, [r8]
	ldr	r9, [r8, r9, lsl #2]
	add r0, r0, r9

	@ calculate start y co-ord
	mov	r10, #SCREEN_PITCH
	mov	r5, r0
	
	mov	r8, #SCREEN_HEIGHT/2
	sub	r8, r8, r1, lsr #1
	sub	r8, r8, #1
	mul	r9, r8, r10
	add	r5, r5, r9
	
	mov	r8, #SCREEN_HEIGHT/2
	add	r8, r8, r1, lsr #1
	mul	r9, r8, r10
	add	r0, r0, r9

	ldr	r10, =floor_dist_table
	mov	r9, r1, lsr #1
	add	r1, r10, r9, lsl #1

	rsbs	r8, r8, #SCREEN_HEIGHT
	ble		9f
	
1:
	@ get floor_dist
	ldrh	r10, [r1], #2
	@ adjust floor dist by 1/cos(b)
	ldr	r3, [sp, #8]
	mul	r11, r10, r3

	@ calculate palette offset
	mov	r10, r11, lsr #15
	ldr	r3, [sp, #16]
	add	r3, r3, r10, lsl #8
	str	r3, [sp, #20]
	
	@ calculate floor_x and floor_y
	ldr	r3, [sp, #0]
	mul	r9, r11, r3 @ floor_x = px + floor_dist * cos(a)
	add	r9, r6, r9, asr #16
	
	ldr	r3, [sp, #4]
	mul r10, r11, r3	@ floor_y = py - floor_dist * sin(a)
	sub	r10, r7, r10, asr #16

	@ calculate floor_x % 64, floor_y % 64, and map location
	mov	r3, r9, lsr #6 @ map_x
	sub	r9, r9, r3, lsl #6 @ floor_x
	mov	r4, r10, lsr #6 @ map_y
	sub	r10, r10, r4, lsl #6 @ floor_y

	@ calculate texture offset
	add	r10, r9, r10, lsl #6
	
	@ calculate map offset
	add	r3, r3, r4, lsl #MAP_SIZE_X2
	
	@ grab map value
	ldr		r4, [sp, #12]
	ldrb	r11, [r4, r3]
	add		r11, r11, #3

	@ get texture location for this map value
	add		r3, r2, r11, lsl #12

	@ grab pixel and draw
	ldrb	r11, [r3, r10]
	ldr		r3, [sp, #20]
	ldrb	r11, [r3, r11]
	strb	r11, [r0], #SCREEN_PITCH
	strb	r11, [r5], #-SCREEN_PITCH

	subs		r8, r8, #1
	bgt 1b

9:
	add	sp, sp, #24
	ldmfd	sp!, {r4-r11}
	bx		lr

trigvals:
	.word	0
	.word 0
	.word 0
@tex:	.long	0
	
