#include "main.h"

//#include "sprites.raw.c"
extern const unsigned char sprites_Bitmap[16384];

extern u32 seconds;
extern u8 paltable[256*8];

extern u16 sliceheights[SLICEHEIGHT_TABLE_SIZE];

extern u8 texinc_high_table[TEXINC_TABLE_SIZE];
extern u16 texinc_low_table[TEXINC_TABLE_SIZE];

/* FIXME: objects currently aren't depth sorted. This needs to be fixed :) */

texobject objs[] = {
	{ 400, 100, sprites_Bitmap},
	{ 400, 800, sprites_Bitmap},
	{ 350, 850, sprites_Bitmap + (64*64)},
	{ 300, 900, sprites_Bitmap},
	{ 1400, 1600, sprites_Bitmap},
	{ 1450, 1600, sprites_Bitmap},
	{ 1200, 1660, sprites_Bitmap},
	{ 1300, 1700, sprites_Bitmap},
	{ 1110, 1700, sprites_Bitmap},
	{ 1300, 1650, sprites_Bitmap},
};

#define NUM_OBJECTS 4
#define MAX_VISIBLE_OBJS 5

#define MAX_DIST FIXED(400)

/* struct for storing visiblity details on an object */
typedef struct
{
	texobject* texobj;
	s32 dist, w, h, obj_pa_angle;
} sort_object;

/* lists for sorting in to */
sort_object sort_objs[NUM_OBJECTS];
s16 sort_objs_list[MAX_VISIBLE_OBJS];

void asm_rasterise_obj_line(u32 x, s32 slice_height, const u8* tex, u32 texture_offset, u32 tex_inc_low, u32 tex_inc_high, u8* paltable) CODE_IN_IWRAM;

void objs_draw(s32 px, s32 py, s32 angle, s32* dist_buf)
{
	int i;
	int stime, etime;
	int num_visible_objs = 0;

	char foo[100];

	/* clear sort lists */
	memset(sort_objs, 0, sizeof(sort_object) * NUM_OBJECTS);
	//memset(sort_objs_list, 0, sizeof(u16) * MAX_VISIBLE_OBJS);
	for(i=0; i < MAX_VISIBLE_OBJS; i++)
		sort_objs_list[i] = -1;
	
	stime = seconds;
	for(i=0; i < NUM_OBJECTS; i++)
	{
		texobject* o = &objs[i];
		s32 o_angle;
		int dist, obj_pa_angle;
		s32 slice_height, slice_width;
		s32 width_angle;
		
		o_angle = gba_atan(py - o->y, o->x - px);

		obj_pa_angle = (angle - 30);
		if(obj_pa_angle < 0) obj_pa_angle += 360;
		obj_pa_angle = ((o_angle / 256) - obj_pa_angle);
		if(obj_pa_angle < 0) obj_pa_angle += 360;	
		
		/*if(abs(px - o->x) > abs(py - o->y))
		{
			dist = abs(((px - o->x) << 8) / gba_cos(o_angle));
		} else {
			dist = abs(((py - o->y) << 8) / gba_sin(o_angle));
		}*/
		dist = pythag(px - o->x, py - o->y);
		/* use unadjusted distance for size calculation */
		if(dist < SLICEHEIGHT_TABLE_SIZE)
		{
			slice_height = sliceheights[dist];
		} else {
			slice_height = FIXED(64 * PROJECTION_DISTANCE)  / FIXED(dist);
		}

		/* clip slice_height to prevent silly things happening */
		if(slice_height > SCREEN_HEIGHT*4) slice_height = SCREEN_HEIGHT*4;
		slice_width = slice_height / 2;

		/* and then adjust for comparison with walls */
		dist = (dist * gba_cos(abs(FIXED(obj_pa_angle - 30))));
		
		//sprintf(foo, "obj: angle: %d pa: %d o-pa: %d angle_diff: %d dist: %d height: %d\n", o_angle/256, angle, obj_pa_angle, angle_diff(FIXED_TO_INT(o_angle), angle), FIXED_TO_INT(dist), slice_height); print(foo);
		
		width_angle = slice_width / 4;
		//if(FIXED_TO_INT(o_angle) + width_angle > (angle - 30) && FIXED_TO_INT(o_angle) - width_angle < (angle + 30))
		if(angle_diff(FIXED_TO_INT(o_angle), angle) < (30 + width_angle))
		{
			/* add this object to the visible list */
			sort_objs[num_visible_objs].texobj = o;
			sort_objs[num_visible_objs].dist = dist;
			sort_objs[num_visible_objs].w = slice_width;
			sort_objs[num_visible_objs].h = slice_height;
			sort_objs[num_visible_objs].obj_pa_angle = obj_pa_angle;
			
			num_visible_objs++;
		}
	}
	etime = seconds;
	//sprintf(foo, "position time: %d\n", etime - stime); print(foo);

	/* sort the visible objects */
	stime = seconds;
	for(i=0; i < num_visible_objs; i++)
	{
		/* check if this object is closer than the furthest object on the list */
		if(sort_objs_list[MAX_VISIBLE_OBJS-1] == -1 || sort_objs[i].dist < sort_objs[sort_objs_list[MAX_VISIBLE_OBJS-1]].dist)
		{
			int position, l;

			/* count up through the list to find where this object should go */
			for(position = MAX_VISIBLE_OBJS-1; position >= 0; position--)
			{
				if(sort_objs_list[position]!= -1 && sort_objs[i].dist > sort_objs[sort_objs_list[position]].dist)
				{
					break;
				}
			}
			position++;
	
			/* copy old objects down the list */
			for(l=MAX_VISIBLE_OBJS-1; l > position; l--)
			{
				sort_objs_list[l] = sort_objs_list[l-1];
			}
			sort_objs_list[position] = i;
		}
	}
	etime = seconds;
	//sprintf(foo, "sort time: %d\n", etime - stime); print(foo);

	if(num_visible_objs > MAX_VISIBLE_OBJS)
		num_visible_objs = MAX_VISIBLE_OBJS;

	/*for(i=0; i < num_visible_objs; i++)
	{
		sprintf(foo, "obj: %d order: %d dist: %d\n", sort_objs_list[i],
			i, sort_objs[sort_objs_list[i]].dist); print(foo);
	}*/
	
	/* and draw them */
	stime = seconds;
	
	for(i=num_visible_objs-1; i >= 0; i--)
	{
		sort_object* o = &sort_objs[sort_objs_list[i]];

		int x;
		int x_offset;
		int tex_pos=0, tex_low=0;
		int tex_inc_high, tex_inc_low;
		int y_tex_inc_high, y_tex_inc_low;
		u8* ptable;
		
		s32 start_x, end_x;
	
		x_offset = ((o->obj_pa_angle > 180 ? o->obj_pa_angle - 360 : o->obj_pa_angle) * SCREEN_WIDTH / 60) - (o->w/2);
			
		tex_inc_high = 64 / o->w;
		tex_inc_low = (((64 % o->w) << 16) / o->w);
			
		y_tex_inc_high = 64 / o->h;
		y_tex_inc_low = (((64 % o->h) << 16) / o->h);
					
		start_x = x_offset; end_x = x_offset + o->w;

		if(start_x < 0)
		{
			tex_low = (-start_x) * tex_inc_low;
			tex_pos = (-start_x) * tex_inc_high + (tex_low >> 16);
			tex_low &= 0x0000ffff;

			start_x = 0;
		}
		if(end_x > SCREEN_WIDTH)
		{
			end_x = SCREEN_WIDTH;
		}
		
		ptable = paltable + (FIXED_TO_INT(o->dist) /128) * 256;
		//sprintf(foo, "drawing object %d : sx: %d ex: %d\n", i, start_x, end_x); print(foo);
		for(x=start_x; x < end_x; x++)
		{
			if(FIXED_TO_INT(o->dist) < dist_buf[x])
			{
				asm_rasterise_obj_line(x, o->h, o->texobj->tex, tex_pos,
					y_tex_inc_low, y_tex_inc_high, ptable);
			}
			tex_low += tex_inc_low;
			if(tex_low > (1 << 16))
			{
				tex_low -= (1 << 16);
				tex_pos++;
			}
			tex_pos += tex_inc_high;
		}
	}
	etime = seconds;
	//sprintf(foo, "raster time: %d\n", etime - stime); print(foo);
}

