#include "main.h"

u32 seconds;

extern u32 gba_bank;

extern const unsigned char map_Bitmap[1024];

const u8* map = map_Bitmap;

extern const unsigned char walltextures_Bitmap[16384];
extern const unsigned short walltextures_Palette[256];

//s32 px = 400; s32 py = 160; s32 pa = 180;
s32 px = 350; s32 py = 700; s32 pa = 270;
//s32 px = 264; s32 py = 771; s32 pa = 355;

#define MOVE_UP		1 << 0
#define MOVE_DOWN	1 << 1
#define MOVE_SL		1 << 2
#define MOVE_SR		1 << 3
#define MOVE_TL		1 << 4
#define MOVE_TR		1 << 5


//#define TRACE(x...) printf(x)
//#define TRACE(x...) sprintf(foo, x); print(foo)
#define TRACE(x...)

#define FIXED(x) ((int)((x) * 256))
#define FIXED_TO_INT(x) ((x)  >> 8)

// debugging output for VBA
void print(char *s)
{
    asm volatile("mov r0, %0;"
                 "swi 0xff;"
                 : // no ouput
                 : "r" (s)
                 : "r0");
		
}

void asm_rasterise_line(u32 x, s32 slice_height, const u8* tex, u32 texture_offset, u32 l, u32 h, u8* paltable) CODE_IN_IWRAM;

#ifdef USE_ASM_RASTER
void rasterise_line(u32 x, s32 slice_height, u32 texture_offset)
{
	int y;
	u16* scr = (u16*)VideoBuffer + x;
	int wall_start_y, wall_end_y;
	int tex_pos=0, tex_low=0;
	int tex_inc_high, tex_inc_low;
	
	wall_start_y = (SCREEN_HEIGHT - slice_height)/2;
	wall_end_y = (SCREEN_HEIGHT + slice_height)/2;

	tex_inc_high = 64 / slice_height;
	tex_inc_low = (((64 % slice_height) << 16) / slice_height);
	
	for(y=0; y < wall_start_y; y++)
	{
		scr[y * SCREEN_WIDTH] = 5 | 5 << 8;
	}

	if(slice_height > SCREEN_HEIGHT)
	{
		tex_low = (-wall_start_y) * tex_inc_low;
		tex_pos = (-wall_start_y) * tex_inc_high + (tex_low >> 16);
		tex_low &= 0x0000ffff;

		wall_start_y = 0; wall_end_y = SCREEN_HEIGHT;
	}

	for(y = wall_start_y; y < wall_end_y ; y++)
	{
		if(y >= 0 && y < SCREEN_HEIGHT)
		{
			u16 pix = wall_Bitmap[(tex_pos * 64) + texture_offset];
			scr[y * SCREEN_WIDTH] = pix | pix << 8;
		}
		
		tex_low += tex_inc_low;
		if(tex_low > (1 << 16))
		{
			tex_low -= (1 << 16);
			tex_pos++;
		}
		tex_pos += tex_inc_high;
		
	}

	for(y=wall_end_y; y <SCREEN_HEIGHT; y++)
	{
		scr[y * SCREEN_WIDTH] = 5 | 5 << 8;
	}
}
#endif

u16 sliceheights[SLICEHEIGHT_TABLE_SIZE];

u8 texinc_high_table[TEXINC_TABLE_SIZE];
u16 texinc_low_table[TEXINC_TABLE_SIZE];

u16 floor_dist_table[SCREEN_HEIGHT];

u8 paltable[256 * 8];

void build_sliceheight_table()
{
	int i;
	for(i = 0; i < SLICEHEIGHT_TABLE_SIZE; i++)
	{
		sliceheights[i] = (64 * PROJECTION_DISTANCE)  / i;
	}
	for(i = 0; i < TEXINC_TABLE_SIZE; i++)
	{
		texinc_high_table[i] = 64 / i;
		texinc_low_table[i] = (((64 % i) << 16) / i);
	}
	for(i=SCREEN_HEIGHT/2; i < SCREEN_HEIGHT; i++)
	{
		floor_dist_table[i-(SCREEN_HEIGHT/2)] = (64/*(SCREEN_HEIGHT/2)*/ * PROJECTION_DISTANCE) / (2*(i - (SCREEN_HEIGHT/2)));
	}

	for(i=0; i < 8; i++)
	{
		int c;
		for(c=0; c < 256; c++)
		{
			if(i*32 + c < 256)
			{
				paltable[i*256 + c] = i*32 + c;
			} else {
				paltable[i*256 + c] = 0;
			}
		}
	}
}
void asm_floor_draw(u32 x, s32 slice_height, const u8* tex, s32 cos_a, s32 sin_a, s32 one_over_cos_b, s32 px, s32 py) CODE_IN_IWRAM;

void raycast()
{
	int i;
	char foo[100];
	s32 dbuf[SCREEN_WIDTH];
	int stime, etime;
	int wallraster_time = 0, floorraster_time = 0, raycast_time = 0;
	int bstime, betime;
	
	stime = seconds;
	/* scan across the screen */
	for(i=0; i < SCREEN_WIDTH; i++)
	{
		s32 angle;
		int Xa, Ya;
		int ax, ay;
		int cur_x, cur_y;
		int grid_x, grid_y;
		int wall_hit_x, wall_hit_y;
		int distance;
		int d1, d2;
		int tex_inc_low, tex_inc_high;
		int slice_height;
		int texture_offset; 
	
		bstime = seconds;
		
		angle = FIXED(pa) + (i * (FIXED(60)/SCREEN_WIDTH)) - FIXED(30);
		if(angle < FIXED(0)) angle += FIXED(360);
		if(angle >= FIXED(360)) angle -= FIXED(360);
		
		TRACE("checking ray %d, angle %f\n", i, angle / 256.0);
		
		/* trace horizontal ray/grid intersections */
		
		/* if ray is facing upwards */
		if(angle < FIXED(180))
		{
			/* get vertical co-ord of first grid intersection */
			ay = (py / 64) * (64) - 1;
			
			/* Ya points up */
			Ya = -FIXED(64);
		} else {
			/* get vertical co-ord of first grid intersection */
			ay = (py / 64) * (64) + 64;

			/* Ya points down */
			Ya = FIXED(64);
		}
		
		/* now get horiz co-ord of first grid intersection */
		if(angle == FIXED(90) || angle == FIXED(270))
		{
			ax = FIXED(px); Xa = 0;
		} else if(angle == FIXED(0) || angle == FIXED(180)) {
			ax = 1 << 24; Xa = 1 << 24;
		} else {
			ax = FIXED(px) + ((py - ay)) * gba_one_over_tan(angle);

			/* calculate X increment between intersections */
			Xa = ((-Ya) * gba_one_over_tan(angle)) >> 8;
		}
		
		/* loop until we hit a wall */
		cur_x = ax; cur_y = FIXED(ay);

		TRACE("Tracing horizontally...\n");
		TRACE("Starting at %d/%d, inc by %d/%d\n", cur_x, cur_y, Xa, Ya);

		while(1)
		{
			grid_x = cur_x / (256 * 64);
			grid_y = cur_y / (256 * 64);

			if(grid_x < 0 || grid_x > MAP_SIZE_X || grid_y < 0 || grid_y > MAP_SIZE_Y)
				break;

			TRACE("Looking at %d/%d (%d/%d) for wall\n", cur_x, cur_y, grid_x, grid_y);
			
			if(map[grid_x + (grid_y * MAP_SIZE_X)])
			{
				break;
			}
			cur_x += Xa;
			cur_y += Ya;
		}
		TRACE("wall found!\n");
		cur_x = cur_x >> 8; cur_y = cur_y >> 8;
		wall_hit_x = cur_x; wall_hit_y = cur_y;
		/*if(abs(px - cur_x) > abs(py - cur_y))
		{
			//d1 = abs(((px - cur_x) << 8) / gba_cos(angle));
			d1 = abs(((px - cur_x) * gba_one_over_cos(angle)) >> 8);
		} else {
			//d1 = abs(((py - cur_y) << 8) / gba_sin(angle));
			d1 = abs(((py - cur_y) * gba_one_over_sin(angle)) >> 8);
		}*/
		d1 = pythag(px - cur_x, py - cur_y);
		TRACE("distance: %d\n", d1);
		
		/* trace vertically */

		/* if ray is facing right */
		if(angle > FIXED(90) && angle < FIXED(270))
		{
			/* get vertical co-ord of first grid intersection */
			ax = (px / 64) * (64) - 1;
			
			/* Xa points right */
			Xa = -FIXED(64);
		} else {
			ax = (px / 64) * (64) + 64;
			
			/* Xa points left */
			Xa = FIXED(64);
		}
		
		/* now get horiz co-ord of first grid intersection */
		if(angle == FIXED(90) || angle == FIXED(270))
		{
			ay = 1 << 24; Ya = 1 << 24;
		} else if(angle == FIXED(0) || angle == FIXED(180)) {
			ay = FIXED(py); Ya = 0;
		} else {
			ay = FIXED(py) + (((px - ax)*gba_tan(angle)));

			/* calculate X increment between intersections */
			Ya = ((-Xa) * gba_tan(angle)) >> 8;
		}
		/* loop until we hit a wall */
		cur_x = FIXED(ax); cur_y = ay;

		TRACE("Tracing vertically...\n");
		TRACE("Starting at %d/%d, inc by %d/%d\n", cur_x, ay, Xa, Ya);
		
		while(1)
		{
			grid_x = cur_x >> 14;
			grid_y = cur_y >> 14;

			if(grid_x < 0 || grid_x >= MAP_SIZE_X || grid_y < 0 || grid_y >= MAP_SIZE_Y)
				break;
			
			TRACE("Looking at %d/%d (%d/%d) for wall\n", cur_x, cur_y, grid_x, grid_y);
			
			if(map[grid_x + (grid_y * MAP_SIZE_X)])
			{
				break;
			}
			cur_x += Xa;
			cur_y += Ya;
		}
		TRACE("wall found!\n");

		/* check which of the horizontal trace or the vertical trace found the
		 * nearer wall */
		cur_x = cur_x >> 8; cur_y = cur_y >> 8;
		d2 = pythag(px - cur_x, py - cur_y);
		TRACE("distance: %d\n", d2);
		
		if(d2 < d1)
		{
			wall_hit_x = cur_x; wall_hit_y = cur_y;
			//texture_offset = wall_hit_y % 64;
			texture_offset = wall_hit_y - ((wall_hit_y >> 6) << 6);
			distance = d2;
		} else {
			//texture_offset = wall_hit_x % 64;
			texture_offset = wall_hit_x - ((wall_hit_x >> 6) << 6);
			distance = d1;
		}
		TRACE("Nearest wall hit at %d/%d\n", wall_hit_x, wall_hit_y);

		//distance = pythag(py - wall_hit_y, px - wall_hit_x);

		TRACE("distance: %d ", distance);
		TRACE("beta: %f ", (FIXED(pa) - angle) / 256.0);
		distance = (distance * gba_cos(abs((FIXED(pa) - angle))));

		TRACE("adjusted distance: %d\n", distance);
		
		betime = seconds;
		raycast_time += (betime - bstime);

		if(distance < FIXED(SLICEHEIGHT_TABLE_SIZE))
		{
			slice_height = sliceheights[FIXED_TO_INT(distance)];
		} else {
			slice_height = FIXED(64 * PROJECTION_DISTANCE)  / distance;
		}

		if(slice_height < TEXINC_TABLE_SIZE)
		{
			tex_inc_low = texinc_low_table[slice_height];
			tex_inc_high = texinc_high_table[slice_height];
		} else {
			tex_inc_high = 64 / slice_height;
			tex_inc_low = (((64 % slice_height) << 16) / slice_height);
		}
		
		dbuf[i] = FIXED_TO_INT(distance);
		TRACE("slice height: %d\n", slice_height);

		/* draw here! */
		bstime = seconds;
		asm_rasterise_line(i, slice_height, walltextures_Bitmap + 
			(map[((wall_hit_y/64) * MAP_SIZE_X) + (wall_hit_x/64)] - 1)*64*64,
			texture_offset, tex_inc_low, tex_inc_high,
			paltable + ((FIXED_TO_INT(distance)/128) *256));
		
		betime = seconds;
		wallraster_time += (betime - bstime);
		//sprintf(foo, "%d\n", 	(FIXED_TO_INT(distance)/200) * 32); print(foo);
	
		/* floor textures! */
		bstime = seconds;
		if(slice_height < SCREEN_HEIGHT)
		{
			asm_floor_draw(i, slice_height, walltextures_Bitmap, gba_cos(angle),
				gba_sin(angle), gba_one_over_cos(abs(FIXED(pa) - angle)), 
				px, py); 
		}
		betime = seconds;
		floorraster_time += (betime - bstime);
	}
	etime = seconds;
	//sprintf(foo, "raycast time: %d\n", etime - stime); print(foo);
	
	//sprintf(foo, "wall: %3d floor: %3d raycast: %3d\n", wallraster_time, floorraster_time, raycast_time); print(foo);
	
	stime = seconds;
	objs_draw(px, py, pa, dbuf);
	etime = seconds;
	//sprintf(foo, "objdraw time: %d\n", etime - stime); print(foo);
}

void player_move(s32 angle)
{
	s32 foo;
	s32 speed = 10;

#define WALL_OFFSET 10
#define MAP_COORD(x, y) ((((y) >> 6) * MAP_SIZE_X) + ((x) >> 6))		

	foo = px + (((speed + WALL_OFFSET) * gba_cos(angle)) >> 8);
	if(map[MAP_COORD(foo, py)] == 0)
		px = px + (((speed) * gba_cos(angle)) >> 8);
	
	foo = py - (((speed + WALL_OFFSET) * gba_sin(angle)) >> 8);
	if(map[MAP_COORD(px, foo)] == 0)
		py = py - (((speed) * gba_sin(angle)) >> 8);
}

//s32 asmgba_sin(s32 angle) CODE_IN_IWRAM;

#if 0
void trigtest()
{
	int a, i;
	int stime, etime;
	
	char foo[100];
	
	for(a=0; a < 360; a+=10)
	{
		sprintf(foo, "sin(%3d): %f %f\n", a, sin(a * (M_PI / 180.0)), gba_sin(a*256) / 256.0); print(foo);
	}
	for(a=0; a < 360; a+=10)
	{
		//sprintf(foo, "cos(%3d): %f %f\n", a, cos(a * (M_PI / 180.0)), gba_cos(a*256) / 256.0); print(foo);
	}
	for(a=0; a < 360; a+=10)
	{
		//sprintf(foo, "tan(%3d): %f %f\n", a, tan(a * (M_PI / 180.0)), gba_tan(a*256) / 256.0); print(foo);
	}

	// trigbench!
#if 0
	stime = seconds;
	for(i=0; i < 10000; i++)
	{
		for(a=0; a < 360; a++)
		{
			gba_sin(a << 8);
		}
	}
	etime = seconds;
	sprintf(foo, "C sin: %d\n", etime - stime); print(foo);

	stime = seconds;
	for(i=0; i < 10000; i++)
	{
		for(a=0; a < 360; a++)
		{
			asmgba_sin(a << 8);
		}
	}
	etime = seconds;
	sprintf(foo, "asm sin: %d\n", etime - stime); print(foo);
#endif
}
#endif

void asm_fpsmeter(u32 fps) CODE_IN_IWRAM;

int AgbMain()
{
	int i;
	char foo[100];
	
	u32 curtime, lasttime;
	int framewait = 0;
	u32 movement = 0;
	int fps = 0;

	build_sliceheight_table();
	
	REG_TM2CNT = TIMER_FREQ_64 | TIMER_IRQ_ENABLE | TIMER_ENABLE;
	REG_TM2D = (65536 - 262);
	interrupt_init();
	REG_IE |= INT_TM2; // enable timer 2 for seconds counter
  REG_IME = 1;

	//trigtest();
	SetMode(MODE_4 | BG2_ENABLE);
	for(i=0; i < 256; i++)
		BGPaletteMem[i] = walltextures_Palette[i];
	
	gba_initbank();

	//lasttime = gettimeofday_double();
	lasttime = seconds;

	while(1)
	{
		u32 keys = *KEYS;
		
		movement = 0;
		
		if(!(keys & KEY_UP)) movement |= MOVE_UP;
		if(!(keys & KEY_DOWN)) movement |= MOVE_DOWN;
		if(!(keys & KEY_LEFT)) movement |= MOVE_TL;
		if(!(keys & KEY_RIGHT)) movement |= MOVE_TR;
		if(!(keys & KEY_L)) movement |= MOVE_SL;
		if(!(keys & KEY_R)) movement |= MOVE_SR;

		/* handle motion */
		if(movement & MOVE_TL)
		{
			pa -= 5;
		}
		if(movement & MOVE_TR)
		{
			pa += 5;
		}
		if(pa < 0) pa += 360;
		if(pa >= 360) pa -= 360;

		//sprintf(foo, "px: %4d py: %4d pa: %3d\n", px, py, pa); print(foo);

		if(movement & MOVE_UP)
		{
			player_move(FIXED(pa));
		}
				
		if(movement & MOVE_DOWN)
		{
			s32 angle = pa + 180;
			if(angle > 360) angle -= 360;
			player_move(FIXED(angle));
		}
				
		if(movement & MOVE_SL)
		{
			s32 angle = pa - 90;
			if(angle < 0) angle += 360;
			player_move(FIXED(angle));
		}

		if(movement & MOVE_SR)
		{
			s32 angle = pa + 90;
			if(angle > 360) angle -= 360;
			player_move(FIXED(angle));
		}
		
		raycast();
		asm_fpsmeter(fps);

		//gba_vsync();
		gba_swapbank();
		framewait++;
		
		if(framewait == 10)
		{
			curtime = seconds;
			fps = 20 * 1000 / (curtime - lasttime);
			//sprintf(foo, "FPS: %f\n", (10.0 * 1000) / (curtime - lasttime)); print(foo);
			lasttime = curtime;
			framewait = 0;
		}
	}

	return 0;
}
