#include "gba.h"
#include "table.h"

#define FIXED(x) ((int)((x) * 256))

s32 gba_sin(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[angle >> 6];
		} else {
			res = sin_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = -sin_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -sin_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res);
}

s32 gba_one_over_sin(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = one_over_sin_table[angle >> 6];
		} else {
			res = one_over_sin_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = -one_over_sin_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -one_over_sin_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res);
}

s32 gba_cos(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = sin_table[(FIXED(90) - angle) >> 6];
		} else {
			res = -sin_table[(angle - FIXED(90)) >> 6];
		}
	} else {
		if(angle < FIXED(270))
		{
			res = -sin_table[(FIXED(270) - angle) >> 6];
		} else {
			res = sin_table[(angle - FIXED(270)) >> 6];
		}
	}
	
	return(res);
}

s32 gba_one_over_cos(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle < FIXED(90))
		{
			res = one_over_sin_table[(FIXED(90) - angle) >> 6];
		} else {
			res = -one_over_sin_table[(angle - FIXED(90)) >> 6];
		}
	} else {
		if(angle < FIXED(270))
		{
			res = -one_over_sin_table[(FIXED(270) - angle) >> 6];
		} else {
			res = one_over_sin_table[(angle - FIXED(270)) >> 6];
		}
	}
	
	return(res);
}

s32 gba_tan(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle <= FIXED(90))
		{
			res = tan_table[angle >> 6];
		} else {
			res = -tan_table[(FIXED(180) - angle) >> 6];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = tan_table[(angle - FIXED(180)) >> 6];
		} else {
			res = -tan_table[(FIXED(360) - angle) >> 6];
		}
	}
	
	return(res);
}

s32 gba_one_over_tan(s32 angle)
{
	s32 res;
	
	if(angle <= FIXED(180))
	{
		if(angle <= FIXED(90))
		{
			res = tan_table[(90*4) - (angle >> 6)];
		} else {
			res = -tan_table[(90*4) - ((FIXED(180) - angle) >> 6)];
		}
	} else {
		if(angle <= FIXED(270))
		{
			res = tan_table[(90*4) - ((angle - FIXED(180)) >> 6)];
		} else {
			res = -tan_table[(90*4) - ((FIXED(360) - angle) >> 6)];
		}
	}
	
	return(res);
}
s32 gba_atan(s32 y, s32 x)
{
	s32 tanval;
	s32 angle;

	if(x == 0)
	{
		angle = 90 * 4;
	} else if(y == 0) {
		angle = 0;
	} else {
		tanval = abs((y << 8) / x);
		angle = 0;

		while(angle < (90*4)+1)
		{
			if(tan_table[angle] > tanval) break;
			angle++;
		}
	}
	angle = angle * 64;
	
	/* move angle to appropriate quadrant */
	if(x < 0)
	{
		if(y > 0)
		{
			angle = FIXED(180) - angle;
		} else {
			angle = FIXED(180) + angle;
		}
	} else {
		if(y < 0)
		{
			angle = FIXED(360) - angle;
		}
	}

	return angle;
}

s32 angle_normalise(s32 a)
{
	while(a < 0)
	{
		a += 360;
	}
	while(a >= 360)
	{
		a -= 360;
	}
	return a;
}

s32 angle_diff(s32 a1, s32 a2)
{
	s32 d1, d2;
	a1 = angle_normalise(a1); a2 = angle_normalise(a2);
	
	d1 = abs(a1 - a2); 
	if(d1 > 180) d1 = 360 - d1;
	d2 = abs(a2 - a1);
	if(d2 > 180) d2 = 360 - d1;
	return d1 > d2 ? d2 : d1;
}

