#include <math.h> 	//sign and cos stuff
#include "gba.h"         //GBA register definitions
#include "dispcnt.h"     //REG_DISPCNT registerdefines
#include "keypad.h"      //button registers
#include "bg.h"          //background definitions
#include "sprite.h"	/* sprite stuff */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

//extern const unsigned char *sprites_Bitmap;
//extern const unsigned short *sprites_Palette;

#include "sprites.raw.c"
#include "sprites.pal.c"

//Rotation variables (don't worry about them here) done in later chapter
/**********************************************************************************/
FIXED angle = 0;
FIXED zoom = 1<<8;  //zoom is a fixed point number

FIXED SIN[360];	    //Look-Up Tabless for sign and cosign
FIXED COS[360];

// debugging output for VBA
void print(char *s)
{
    asm volatile("mov r0, %0;"
                 "swi 0xff;"
                 : // no ouput
                 : "r" (s)
                 : "r0");
		
}
/**********************************************************************************/

typedef struct
{
	s32 x, y;
	s16 direction;
	Sprite sprite;
	u16 distance_total, distance_travelled, speed;
	u16 active;
} bullet;

#define BULLET_SPEED 4

typedef struct 
{
	s32 x, y;
	u16 direction;
	Sprite sprite;
	u16 xspeed;
	s16 min_x, max_x;
	u16 yspeed;
	s16 min_y, max_y;
	u16 num_bullets;
	bullet* bullets;
	u16 fire_delay;
} playership;

#define PLAYERSHIP_FIRE_DELAY 10
#define PLAYERSHIP_NUM_BULLETS 8

typedef struct
{
	s32 x, y;
	u16 direction;
	u16 speed;
	u16 active;
	Sprite sprite;
} alien;	

playership* ship;

alien aliens[10];
int num_aliens = 10;

playership* playership_new()
{
	int i;
	
	playership* s = malloc(sizeof(playership));
	s->x = 0;
	s->y = 80-8;
	s->direction = 1;
	s->xspeed = 1;
	s->min_x = 0; s->max_x = 240-16;
	s->yspeed = 2;
	s->min_y = 0; s->max_y = 160-16;
	s->fire_delay = 0;

	/* configure sprite details and allocate a sprite */
	s->sprite.bx = 3;		s->sprite.by = 2;
	s->sprite.bw = 12;	s->sprite.bh = 12;
	s->sprite.tile = (4*2) * 0;
	s->sprite.a0 = COLOR_256 | SQUARE;
	s->sprite.a1 = SIZE_16;
	s->sprite.sprite = sprite_alloc();

	/* create bullets */
	s->num_bullets = PLAYERSHIP_NUM_BULLETS;
	s->bullets = malloc(sizeof(bullet) * s->num_bullets);
	
	for(i=0; i < s->num_bullets; i++)
	{
		s->bullets[i].sprite.bx = 0; s->bullets[i].sprite.by = 3;
		s->bullets[i].sprite.bw = 8; s->bullets[i].sprite.bh = 2;
		s->bullets[i].sprite.a0 = COLOR_256 | SQUARE;
		s->bullets[i].sprite.a1 = SIZE_8;
		s->bullets[i].sprite.tile = (4*2) * 2;
		
		s->bullets[i].distance_total = 240;
		s->bullets[i].direction = 1;
		
		s->bullets[i].active = 0;
	}

	return s;
}

void playership_read_keys(playership* ship, u32 keys)
{
	if(!(keys & KEY_UP))
	{
		ship->y -= ship->yspeed;
		if(ship->y < ship->min_y) ship->y = ship->min_y;
	}

	if(!(keys & KEY_DOWN))
	{
		ship->y += ship->yspeed;
		if(ship->y > ship->max_y) ship->y = ship->max_y;
	}

	if(!(keys & KEY_LEFT))
	{
		ship->x -= ship->xspeed;
		if(ship->x < ship->min_x) ship->x = ship->min_x;
	}
	
	if(!(keys & KEY_RIGHT))
	{
		ship->x += ship->xspeed;
		if(ship->x > ship->max_x) ship->x = ship->max_x;
	}

	if(!(keys & KEY_A))
	{
		/* fire :) */
		if(ship->fire_delay == 0)
		{
			/* cool, we can fire - find a free bullet */
			int i;
			
			for(i=0; i < ship->num_bullets; i++)
			{
				if(ship->bullets[i].active == 0)
				{
					/* found one - fire it */
					bullet* b = &ship->bullets[i];
					b->x = ship->x + 16;
					b->y = ship->y + 4;
					b->distance_travelled = 0;
					b->active = 1;
					b->speed = BULLET_SPEED;
					b->sprite.sprite = sprite_alloc();

					/* set fire delay, and break out of bullet-finding loop */
					ship->fire_delay = PLAYERSHIP_FIRE_DELAY;
					break;
				}
			}
		}
	}
}

void playership_draw(playership* ship)
{
	int i;
	
	ship->sprite.x = ship->x; ship->sprite.y = ship->y;
	DRAW_SPRITE(ship->sprite);

	/* handle firing */

	/* decrement fire delay if we've recently fired a bullet */
	if(ship->fire_delay > 0) ship->fire_delay--;
	
	/* move and draw bullets */
	for(i=0; i < ship->num_bullets; i++)
	{
		bullet* b = &ship->bullets[i];
		
		if(b->active)
		{
			b->distance_travelled += b->speed;
			b->x += b->speed;
			if(b->distance_travelled > b->distance_total)
			{
				b->active = 0;
				sprite_free(b->sprite.sprite);
			}

			b->sprite.x = b->x;
			b->sprite.y = b->y;
			DRAW_SPRITE(b->sprite);
		}
	}
}

void aliens_create_wave()
{
	int i;
	for(i=0; i < 4; i++)
	{
		alien* a = &aliens[i];
		a->x = 240 + (i * 20);
		//a->y = rand() / (RAND_MAX / (160-16));
		a->y = i * 30;
		a->active = 1;
		a->speed = 1;
		
		a->sprite.sprite = sprite_alloc(); //20 + i;
		a->sprite.bx = 2;		a->sprite.by = 2;
		a->sprite.bw = 12;	a->sprite.bh = 12;
		a->sprite.tile = (4*2) * 1;
		a->sprite.a0 = COLOR_256 | SQUARE;
		a->sprite.a1 = SIZE_16;
	}
}

void aliens_draw()
{
	int i;
	for(i=0; i < num_aliens; i++)
	{
		alien* a = &aliens[i];
		if(a->active)
		{
			a->x -= a->speed;
			if(a->x <= -16) a->active = 0;
			a->sprite.x = a->x; a->sprite.y = a->y;
			DRAW_SPRITE(a->sprite);
		}
	}
}

/* macro for checking collision of bounding boxes */

#define BOUNDS_COLLIDE(minx1, miny1, w1, h1, minx2, miny2, w2, h2) \
 (((minx1 + w1) >= minx2) && (minx1 <= (minx2 + w2)) && \
	((miny1 + h1) >= miny2) && (miny1 <= (miny2 + h2)))

#define SPRITE_BOUNDS_COLLIDE(s1, s2) \
 (((s1.x + s1.bx + s1.bw) >= (s2.x + s2.bx)) && \
	((s1.x + s1.bx) <= (s2.x + s2.bx + s2.bw)) && \
  ((s1.y + s1.by + s1.bh) >= (s2.y + s2.by)) && \
	((s1.y + s1.by) <= (s2.y + s2.by + s2.bh)))
 
void collide_aliens_bullets_ship(playership* s)
{
	int i;

	/* iterate through the aliens */
	for(i=0; i < num_aliens; i++)
	{
		alien* a = &aliens[i];

		if(a->active)
		{
			/* check this alien against the ship */

			if(SPRITE_BOUNDS_COLLIDE(ship->sprite, a->sprite))
			{
				print("kaboom!\n");
			}
			
			/* check this alien against each bullet in turn */
			int bul;
			for(bul=0; bul < ship->num_bullets; bul++)
			{
				bullet* b = &ship->bullets[bul];
				if(b->active)
				{
					/* we have an active bullet and an active alien - see if they
					 * collide */
					
					/* check x and y bounds */
					if(SPRITE_BOUNDS_COLLIDE(b->sprite, a->sprite))
					{
						/* woo - the alien and bullet bounding boxes collide */

						/* we should do a per-pixel comparison of the sprite data to make
						 * sure the objects (as opposed to their bounding boxes) have
						 * collided - do this later :) */

						b->active = 0;
						a->active = 0;
						sprite_free(b->sprite.sprite);
						sprite_free(a->sprite.sprite);
					}
				}
			}
		}
	}
}

//declare an instance of the background structure
Bg bg2;
int x_off, y_off;

//wait for the screen to stop drawing
void WaitForVsync()
{
	while((volatile u16)REG_VCOUNT != 160){}
}

///main entry point from the boot.asm startup file
int AgbMain()
{
	u16 loop;
	u16* temp;      //temporary storage pointer
	int wave_timer = 0;
	ship = playership_new();
	
	//interrupt_init();
	
	//set mode 2 and enable sprites and 1d mapping
	SetMode(MODE_2 | BG2_ENABLE | OBJ_ENABLE | OBJ_MAP_1D);

	/* load sprite palette and tile data */
	for(loop = 0; loop < 256; loop++)
	{
		OBJPaletteMem[loop] = sprites_Palette[loop];
	}
	
	InitialiseSprites();
	temp = (u16*) sprites_Bitmap;
	for(loop = 0; loop < (2 * 16) * 32; loop++)
	{
		OAMData[loop] = temp[loop];
	}
	
	//Main Game loop
	while(1)
	{
		u32 keys = *KEYS;

		if(wave_timer == 0)
		{
			aliens_create_wave();
			wave_timer = 350;
		}
		wave_timer--;

		playership_read_keys(ship, keys);
		aliens_draw();
		playership_draw(ship);
		collide_aliens_bullets_ship(ship);

		CopyOAM();
		gba_vsync();
	}
	return(0);
}
