#include "main.h"

//#include "graphics/intro_planet.pal.c"
//#include "graphics/intro_planet.raw.c"

void intro()
{
	Bg planetbg;
	s32 loop;
	u16* temp;
	u32 x, y;
	int start=0;

	InitialiseSprites();

	/* set to mode 0 */
	SetMode(MODE_0 | BG0_ENABLE | OBJ_ENABLE | OBJ_MAP_1D);
	
	planetbg.number = 0;
	planetbg.charBaseBlock = 0;
	planetbg.screenBaseBlock = 28;		//map data position on 2Kb boundary
	planetbg.colorMode = BG_COLOR_256;           //256-colour background
	planetbg.size = TEXTBG_SIZE_256x256;
	planetbg.mosaic = 0;                         //not enabled
	planetbg.wraparound = 0;
	planetbg.x_scroll = 0;			//scrolling variables
	planetbg.y_scroll = 0;

	EnableBackground(&planetbg);

	/* load tile and palette data */
	temp = (u16*)intro_planet_Bitmap;
	for(loop=0; loop < 32 * (30 * 4); loop++)
		planetbg.tileData[loop] = temp[loop];
	
	/* generate map data */
	/* the planet map tiles consist of 60 (two lines of 30) tiles of random
	 * stars, followed by 60 tiles of planet image. */
	for(y=0; y < 30; y++)
	{
		for(x=0; x < 30; x++)
		{
			int f = (rand() / (RAND_MAX / 60));
			planetbg.mapData[(32 * y) + x] = f;
		}
	}
	for(y=30; y < 32; y++)
	{
		for(x=0; x < 30; x ++)
		{
			planetbg.mapData[(32 * y) + x] = 60 + (30 * (y - 30)) + x;
		}
	}
	
	/* scroll map from starry screen at top to reveal planet at bottom */
	for(y=0; y < (256 - 160); y++)
	{
		u32 keys = *KEYS;
		if(!(keys & KEY_A)) y = (256 - 160);

		if(y < 32)
		{
			palette_fade_to_black(intro_planet_Palette, BGPaletteMem, 256, y * (256 / 32));
		}
		planetbg.y_scroll = y;
		UpdateBackground(&planetbg);
		gba_vsync();
		gba_vsync();
	}
	
	for(loop=0; loop < 256; loop++)
		BGPaletteMem[loop] = intro_planet_Palette[loop];

	/* load sprite palette and tile data */
	for(loop = 0; loop < 256; loop++)
	{
		OBJPaletteMem[loop] = sprites_Palette[loop];
	}
	
	temp = (u16*) sprites_Bitmap;
	for(loop = 0; loop < (2 * 16) * (32*8); loop++)
	{
		OAMData[loop] = temp[loop];
	}

	/* scroll title banner down from the top of the screen */
	for(loop=-32; loop < 50; loop++)
	{
		u32 keys = *KEYS;
		if(!(keys & KEY_A)) loop = 50;
		
		palette_fade_to_black(sprites_Palette, OBJPaletteMem, 256, (loop+32) * 256 / 82);
		
		for(y=0; y<2; y++)
		{
			for(x=0; x<13; x++)
			{
				int s = y*13 + x;
				sprites[s].attribute0 = COLOR_256 | SQUARE | MOSAIC | ((loop + (y*16)) & 0xff);
				sprites[s].attribute1 = SIZE_16 | (120 - (200/2) + x*16);
				sprites[s].attribute2 = (4*2) * (32 + (16*y) + x);
			}
		}
		CopyOAM();
		gba_vsync();
	}
	
	/* scroll "press start" text up from the bottom */
	for(loop=240; loop > (120 - (96/2)); loop-=4)
	{
		u32 keys = *KEYS;
		if(!(keys & KEY_A)) loop = (120 - (96/2));

		for(x=0; x<6; x++)
		{
			int s = 40 + x;
			sprites[s].attribute0 = COLOR_256 | SQUARE | MOSAIC | 90;
			sprites[s].attribute1 = SIZE_16 | (loop + (x*16));
			sprites[s].attribute2 = (4*2) * (25 + x);
		}
		CopyOAM();
		gba_vsync();
	}

	while(!start)
	{
		u32 keys = *KEYS;
		if(!(keys & KEY_START))
		{
			start = 1;
		}
		gba_vsync();
	}
	
	/* do a nice mosaic effect to fade out */
	REG_BG0CNT |= BG_MOSAIC_ENABLE;
	mosaic_fade(intro_planet_Palette, sprites_Palette);

	memset(planetbg.mapData, 0, 32 * 32 * 2);
}
