
typedef struct
{
	char	name[23];
	u32		length;
	u8		finetune;
	u8		volume;
	u32		loop_start;
	u32		loop_end;
	s8*		data;

} mod_sample;

typedef struct
{
	u8 sample_number;
	u8 note;
	u8 effect_number, effect_params;
} mod_note;

typedef struct
{
	u16 channels;
	u16 length;
	
	mod_note* data;
} mod_pattern;

typedef struct
{
	char				name[21];
	
	u16 num_samples;
	mod_sample	samples[31];

	u16 length;
	u16 order[128];

	u16 num_patterns;
	mod_pattern* patterns;

	/* playing state */
	u32 pattern;
	u32	line;

	u32	master_volume;

} mod_header;

#define AMIGA_PERIOD_TO_HZ(x) (7159090 / ((x) * 2))

void mod_parse(mod_header* m, const u8* data);
void mod_play(mod_header* m, u16* channels);

