///////////////////////////////////////////////////////////////////////////////
// sfx.h
///////////////////////////////////////////////////////////////////////////////

#ifndef SFX_H
#define SFX_H

// some defines
#define SND_ENABLED           0x00000080
#define SND_OUTPUT_RATIO_25   0x0000
#define SND_OUTPUT_RATIO_50   0x0001
#define SND_OUTPUT_RATIO_100  0x0002
#define DSA_OUTPUT_RATIO_50   0x0000
#define DSA_OUTPUT_RATIO_100  0x0004
#define DSA_OUTPUT_TO_RIGHT   0x0100
#define DSA_OUTPUT_TO_LEFT    0x0200
#define DSA_OUTPUT_TO_BOTH    0x0300
#define DSA_TIMER0            0x0000
#define DSA_TIMER1            0x0400
#define DSA_FIFO_RESET        0x0800
#define DSB_OUTPUT_RATIO_50   0x0000
#define DSB_OUTPUT_RATIO_100  0x0008
#define DSB_OUTPUT_TO_RIGHT   0x1000
#define DSB_OUTPUT_TO_LEFT    0x2000
#define DSB_OUTPUT_TO_BOTH    0x3000
#define DSB_TIMER0            0x0000
#define DSB_TIMER1            0x4000
#define DSB_FIFO_RESET        0x8000
#define FREQUENCY             16000
//#define TIMER_INTERVAL        0xFD07    // (65536-(round((2^24)/FREQUENCY)))
#define TIMER_INTERVAL        0xFbe8    // (65536-(round((2^24)/FREQUENCY)))
#define SAMPLES_PER_VBLANK    0x0170    // (FREQUENCY/60)

// a typedef for a sample
typedef struct
{
	const s8  *pData;			// pointer to the raw sound data
	u32 length;						// the size of the sample
	u16 volume, panning;	// volume and panning (0 - 16 for vol, -8 - 8 for pan)
	u16 freq;
	u32 start_offset;			// offset to start playing at
	u32	loop_start, loop_end;
} sfxSystemSound;

// function declarations
/* start and stop sound system */
void sfxSystemInit();
void sfxSystemStop();

/* worker - call once every frame */
u32 sfxSystemWorker();

/* standard sound playing functions */
void sfxSystemPlay(const sfxSystemSound* pSample);

/* channel allocation */
int sfxSystemAllocChannel();
void sfxSystemSetChannel(u16 i, const sfxSystemSound* s);
void sfxSystemFreeChannel(u16 channel);

void sfxSystemChannelSetVolume(u16 i, u16 vol);
void sfxSystemChannelSetPanning(u16 i, s16 pan);
void sfxSystemChannelSetOffset(u16 i, u32 off);
void sfxSystemChannelSetFreq(u16 i, u16 freq);

#endif
