
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995,1996  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifndef XKOBO_H_CONFIG
#define XKOBO_H_CONFIG

#ifndef XKOBO_SCORE_DIR
#ifdef __WIN32__
#define XKOBO_SCORE_DIR  "scores"
#else
#define XKOBO_SCORE_DIR  "/usr/share/games/xkobo"
#endif
#endif

#ifndef WAIT_MSEC
#define WAIT_MSEC	30
#endif

#ifndef SHIPS
#define SHIPS		5
#endif

#undef	USE_NO_FRAME
#define	USE_NICE_FRAME

#define BEAM_MAX	10
#define ENEMY_MAX	1024

#ifdef	USE_NO_FRAME
#	define WSIZE	224
#	define MARGIN	8
#else
	/*
	 * Note that this adds 8 "partially" visible
	 * pixels around the screen, which could mean
	 * that some objects can be created or deleted
	 * in view. Finding out whether or not it can
	 * really happen calls for closer analysis of
	 * the code.
	 *
	 * NOTE:  I *DON'T* want to change the view
	 *        range as the XKobo engine knows it,
	 *        as that would make the game play
	 *        slightly differently. (Probably not
	 *        so that anyone would notice, but
	 *        let's not take chances... This is
	 *        NOT "Kobo II".)
	 */
#	define WSIZE	230
#	define MARGIN	5
#endif

#define VIEWLIMIT	224

#define HIT_MYSHIP	5
#define HIT_BEAM	5

#define WSCORE_SIZEX	250
#define WSCORE_SIZEY	240

/*#define	SCREEN_WIDTH	320
#define	SCREEN_HEIGHT	240*/

////////////////////////////////////////////////////////////////////////////

#define CHIP_SIZEX_LOG2   4
#define CHIP_SIZEY_LOG2   4
#define MAP_SIZEX_LOG2    6
#define MAP_SIZEY_LOG2    7
#define WORLD_SIZEX_LOG2 (MAP_SIZEX_LOG2+CHIP_SIZEX_LOG2)
#define WORLD_SIZEY_LOG2 (MAP_SIZEY_LOG2+CHIP_SIZEY_LOG2)

#define CHIP_SIZEX        (1<<CHIP_SIZEX_LOG2)
#define CHIP_SIZEY        (1<<CHIP_SIZEY_LOG2)
#define MAP_SIZEX         (1<<MAP_SIZEX_LOG2)
#define MAP_SIZEY         (1<<MAP_SIZEY_LOG2)
#define WORLD_SIZEX      (1<<WORLD_SIZEX_LOG2)
#define WORLD_SIZEY      (1<<WORLD_SIZEY_LOG2)

#endif // XKOBO_H_CONFIG
