#include <math.h> 	
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "gba.h"       
#include "dispcnt.h"
#include "keypad.h"
#include "bg.h"
#include "sprite.h"
#include "interrupt.h"

extern const unsigned char intro_planet_Bitmap[7680];
extern const unsigned short intro_planet_Palette[256];
extern const unsigned char font_Bitmap[4096];
extern const unsigned short sprites_Palette[256];
extern const unsigned char sprites_Bitmap[16384];


/* explosion animation info */
#define EXPLOSION_FRAMES_NUM 5
#define EXPLOSION_FRAMES_START 5

void write_score(u16* map, u16 map_width, u16 x, u16 y, int val, int pad);
void print(char* x);

#include "player.h"
#include "aliens.h"

typedef struct {
	playership* ship;
	alien* aliens;
	u32 num_aliens;
	u16* charMap;
} game;

playership* playership_new();
void playership_read_keys(playership* ship, u32 keys);
void playership_draw(game* g);

void aliens_create_wave_blue(alien* aliens, int num);
void aliens_create_wave_purple(alien* aliens, int num);
void aliens_free_wave(alien* aliens, int num);
void aliens_draw(game* g);
int collide_aliens_bullets_ship(game* g);

int game_run();

void palette_fade_to_black(const u16* in, u16* out, int len, int amount);
void mosaic_fade(const u16* bgpal, const u16* spritepal);

void intro();
