#include "main.h"

/**
 * Fade a palette to black
 * @param in input palette
 * @param out output palette
 * @param len number of entries in palette
 * @param amount amount to fade: 256 = no change, 0 = fully black
 */
void palette_fade_to_black(const u16* in, u16* out, int len, int amount)
{
	int i;
	if(amount > 256 || amount < 0) return;

	for(i=0; i<len; i++)
	{
		u32 r, g, b;
		u16 cur;
		
		cur = in[i];
		r = cur & 0x1f;
		g = (cur >> 5) & 0x1f;
		b = (cur >> 10) & 0x1f;

		r = (r * amount) >> 8;
		g = (g * amount) >> 8;
		b = (b * amount) >> 8;

		cur = r | (g << 5) | (b << 10);
		out[i] = cur;
	}
}

/**
 * Do a nice mosaic + fade out effect
 * @param bgpal background palette data
 * @param spritepal sprite palette data
 */
void mosaic_fade(const u16* bgpal, const u16* spritepal)
{
	int x, y;
	for(x=0; x < 16; x++)
	{
		REG_MOSAIC = x * 0x1111;
	
		for(y=0; y<16; y+=4)
		{
			palette_fade_to_black(bgpal, BGPaletteMem, 256, 256 - ((x * 16) + y));
			palette_fade_to_black(spritepal, OBJPaletteMem, 256, 256 - ((x * 16) + y));
			gba_vsync();
		}
	}
	REG_MOSAIC = 0;
}
