#include "main.h"

#define PLAYERSHIP_FRAME_NORMAL	0
#define PLAYERSHIP_FRAME_UP			1
#define PLAYERSHIP_FRAME_DOWN		2

#define PLAYERSHIP_BULLET_TILE	(4*2 * 20)

playership* playership_new()
{
	int i;
	
	playership* s = malloc(sizeof(playership));
	s->x = FIXED_INT(0);
	s->y = FIXED_INT(80-8);
	s->direction = 1;
	s->xspeed = FIXED_INT(1.2);
	s->min_x = FIXED_INT(0); s->max_x = FIXED_INT(240-16);
	s->yspeed = FIXED_INT(2);
	s->min_y = FIXED_INT(0); s->max_y = FIXED_INT(160-16);
	s->fire_delay = 0;
	s->score = 0;

	/* configure sprite details and allocate a sprite */
	s->sprite.bx = 3;		s->sprite.by = 2;
	s->sprite.bw = 12;	s->sprite.bh = 12;
	s->sprite.a0 = COLOR_256 | SQUARE;
	s->sprite.a1 = SIZE_16;
	s->sprite.tile = (4*2) * PLAYERSHIP_FRAME_NORMAL;
	s->sprite.sprite = sprite_alloc();

	/* create bullets */
	s->num_bullets = PLAYERSHIP_NUM_BULLETS;
	s->bullets = malloc(sizeof(bullet) * s->num_bullets);
	
	for(i=0; i < s->num_bullets; i++)
	{
		s->bullets[i].sprite.bx = 0; s->bullets[i].sprite.by = 3;
		s->bullets[i].sprite.bw = 8; s->bullets[i].sprite.bh = 2;
		s->bullets[i].sprite.a0 = COLOR_256 | SQUARE;
		s->bullets[i].sprite.a1 = SIZE_8;
		s->bullets[i].sprite.tile = PLAYERSHIP_BULLET_TILE;
		
		s->bullets[i].distance_total = FIXED_INT(240);
		s->bullets[i].direction = 1;
		
		s->bullets[i].active = 0;
	}

	return s;
}

void playership_read_keys(playership* ship, u32 keys)
{
	u16 frame = PLAYERSHIP_FRAME_NORMAL;
	
	if(!(keys & KEY_UP))
	{
		ship->y -= ship->yspeed;
		if(ship->y < ship->min_y) ship->y = ship->min_y;
		frame = PLAYERSHIP_FRAME_UP;
	}

	if(!(keys & KEY_DOWN))
	{
		ship->y += ship->yspeed;
		if(ship->y > ship->max_y) ship->y = ship->max_y;
		frame = PLAYERSHIP_FRAME_DOWN;
	}

	if(!(keys & KEY_LEFT))
	{
		ship->x -= ship->xspeed;
		if(ship->x < ship->min_x) ship->x = ship->min_x;
	}
	
	if(!(keys & KEY_RIGHT))
	{
		ship->x += ship->xspeed;
		if(ship->x > ship->max_x) ship->x = ship->max_x;
	}

	ship->sprite.tile = (4*2) * frame;

	if(!(keys & KEY_A))
	{
		/* fire :) */
		if(ship->fire_delay == 0)
		{
			/* cool, we can fire - find a free bullet */
			int i;
			
			for(i=0; i < ship->num_bullets; i++)
			{
				if(ship->bullets[i].active == 0)
				{
					/* found one - fire it */
					bullet* b = &ship->bullets[i];
					b->x = ship->x + FIXED_INT(16);
					b->y = ship->y + FIXED_INT(4);
					b->distance_travelled = 0;
					b->active = 1;
					b->speed = BULLET_SPEED;
					b->sprite.sprite = sprite_alloc();

					/* set fire delay, and break out of bullet-finding loop */
					ship->fire_delay = PLAYERSHIP_FIRE_DELAY;
					break;
				}
			}
		}
	}
}

void playership_draw(game* g)
{
	int i;
	playership* ship = g->ship;
	
	ship->sprite.x = FIXED_TO_INT(ship->x);
	ship->sprite.y = FIXED_TO_INT(ship->y);
	
	DRAW_SPRITE(ship->sprite);

	write_score(g->charMap, 256 / 8, 30 - 6, 20 - 1, ship->score, 6);
	
	/* handle firing */

	/* decrement fire delay if we've recently fired a bullet */
	if(ship->fire_delay > 0) ship->fire_delay--;
	
	/* move and draw bullets */
	for(i=0; i < ship->num_bullets; i++)
	{
		bullet* b = &ship->bullets[i];
		
		if(b->active)
		{
			b->distance_travelled += b->speed;
			b->x += b->speed;
			if(b->distance_travelled > b->distance_total)
			{
				b->active = 0;
				sprite_free(b->sprite.sprite);
			}

			b->sprite.x = FIXED_TO_INT(b->x);
			b->sprite.y = FIXED_TO_INT(b->y);
			DRAW_SPRITE(b->sprite);
		}
	}
}

