#include "gba.h"
#include "sound.h"

#define	INT_TM0		(0x0008)

#include "laser2.h"
#include "exp2.h"

u8* loc_sample;
u32 cur_sample, num_samples, sound_playing;

//SAMPLE laser_sample = {laser_wav, 4032};
SAMPLE laser_sample = {laser_wav, 3000};
SAMPLE exp_sample = {exp_wav, 16128};

// init_sfx_system - sets the registers for enabling the sound hardware and
//                   Direct Sound
// PARAMETERS:  none
// RETURNS:     none
void init_sfx_system(void)
{
	// turn on the sound chip
	REG_SOUNDCNT_X = SND_ENABLED;

	// make sure sound channels 1-4 are turned off
	REG_SOUNDCNT_L = 0;

	// set the direct sound output control register
	REG_SOUNDCNT_H = SND_OUTPUT_RATIO_100 | // 100% sound output
		DSA_OUTPUT_RATIO_100 | // 100% direct sound A output
		DSA_OUTPUT_TO_BOTH |   // output Direct Sound A to both right and left speakers
		DSA_TIMER0 |           // use timer 0 to determine the playback frequency of Direct Sound A
		DSA_FIFO_RESET;        // reset the FIFO for Direct Sound A
}

// play_sfx - starts the DMA of a sample and waits for it to complete
// PARAMETERS:  pSample - a pointer to the sample we want to play
// RETURNS:     none
void play_sfx(const SAMPLE *pSample)
{
	// make sure Timer 0 is off
	REG_TM0CNT = 0;

	// make sure DMA channel 1 is turned off
	//REG_DMA1CNT = 0;

	// make sure the FIFO is reset
	REG_SOUNDCNT_H |= DSA_FIFO_RESET;   // just set the reset bit and leave the other ones alone

	REG_TM0D = 0xfa0e;
	REG_TM0CNT = TIMER_IRQ_ENABLE | TIMER_ENABLE | 0;
	
	cur_sample = 0;
	num_samples = pSample->length;
	loc_sample = pSample->pData;
	sound_playing = 1;

	REG_IE |= INT_TM0;
	REG_IME = 1;
	
	// start the timer using the appropriate frequency
	/*REG_TM0D   = TIMER_INTERVAL;
	REG_TM0CNT = TIMER_ENABLE;

	// start the DMA transfer on channel 1
	REG_DMA1SAD = (u32)(pSample->pData);
	REG_DMA1DAD = (u32)REG_FIFO_A;
	REG_DMA1CNT = ENABLE_DMA | START_ON_FIFO_EMPTY | WORD_DMA | DMA_REPEAT;

	// set up timer 1 as a sample length counter
	REG_TM1D = 0xffff - pSample->length;
	REG_TM1CNT = TIMER_CASCADE | TIMER_IRQ_ENABLE | TIMER_ENABLE;

	// and enable interrupt used to stop the sample playing when it's finished
	REG_IE |= INT_TM1;
	REG_IME = 1;*/
}
