#define BG_C

#include "gba.h"
#include "bg.h"
#include "dispcnt.h"

/*extern FIXED COS[360];
extern FIXED SIN[360];*/
void RotateBackground(Bg* bg);

void EnableBackground(Bg* bg)
{
	u16 temp;

	bg->tileData = (u16*)CharBaseBlock(bg->charBaseBlock);
	bg->mapData = (u16*)ScreenBaseBlock(bg->screenBaseBlock);
	temp = bg->size | (bg->charBaseBlock<<CHAR_SHIFT) | (bg->screenBaseBlock<<SCREEN_SHIFT)
		| bg->colorMode | bg->mosaic | bg->wraparound;

	switch(bg->number)
	{
	case 0:
		{
			REG_BG0CNT = temp;
			REG_DISPCNT |= BG0_ENABLE;
		}break;
	case 1:
		{
			REG_BG1CNT = temp;
			REG_DISPCNT |= BG1_ENABLE;
		}break;
	case 2:
		{
			REG_BG2CNT = temp;
			REG_DISPCNT |= BG2_ENABLE;
		}break;
	case 3:
		{
			REG_BG3CNT = temp;
			REG_DISPCNT |= BG3_ENABLE;
		}break;

	default:break;

	}
}

void UpdateBackground(Bg* bg)
{
	switch(bg->number)
	{
	case 0:
		REG_BG0HOFS = bg->x_scroll;
		REG_BG0VOFS = bg->y_scroll;
		break;
	case 1:
		REG_BG1HOFS = bg->x_scroll;
		REG_BG1VOFS = bg->y_scroll;
		break;
	case 2:
		if(!(REG_DISPCNT & MODE_0))//it is a rot background
		{
			RotateBackground(bg);
			REG_BG2X = bg->DX;
			REG_BG2Y = bg->DY;

			REG_BG2PA = bg->PA;
			REG_BG2PB = bg->PB;
			REG_BG2PC = bg->PC;
			REG_BG2PD = bg->PD;
		}
		else  //it is a text background
		{
			REG_BG2HOFS = bg->x_scroll;
			REG_BG2VOFS = bg->y_scroll;
		}
		break;
	case 3:
		if(!(REG_DISPCNT & MODE_0))//it is a rot background
		{
			REG_BG3X = bg->DX;
			REG_BG3Y = bg->DY;

			REG_BG3PA = bg->PA;
			REG_BG3PB = bg->PB;
			REG_BG3PC = bg->PC;
			REG_BG3PD = bg->PD;
		}
		else //it is a text background
		{
			REG_BG3HOFS = bg->x_scroll;
			REG_BG3VOFS = bg->y_scroll;
		}
		break;
	default: break;
	}
}

void RotateBackground(Bg* bg)
{

	/*center_y = (center_y * zoom)>>8;
	center_x = (center_x * zoom)>>8;

	bg->DX = ((bg->x_scroll<<8)-center_y*SIN[angle]-center_x*COS[angle]);
	bg->DY = ((bg->y_scroll<<8)-center_y*COS[angle]+center_x*SIN[angle]);

	bg->PA = (COS[angle]*zoom)>>8;  //cos&sin are LUTs that are .8 fixed numbers
	bg->PB = (SIN[angle]*zoom)>>8;  //zoom is also fixed
	bg->PC = (-SIN[angle]*zoom)>>8;
	bg->PD = (COS[angle]*zoom)>>8;*/

	bg->PA = 1 << 8; bg->PD = 1 << 8;
	bg->PB = 0; bg->PC = 0;

	bg->DX = bg->x_scroll;
	bg->DY = bg->y_scroll;
}
