#include "gba.h"
#include "sound.h"

void (*IntrTable[14])(void);

void interrupt_dummy(void) {
};

void interrupt_key(void) {
  asm volatile ("\n\
      mov	a1, #0x8c	@ Point at BIOS hard reset.\n\
      bx	a1		@ Go."
  );
}

extern u32 cur_sample, num_samples, sound_playing;
extern u8* loc_sample;
extern u16 fifo_stalled;

void interrupt_sound(void)
{ 
	REG_TM0CNT=0; //disable timer 0
	REG_DMA1CNT=0; //stop DMA
	REG_TM1CNT=0;
	fifo_stalled = 1;
	//clear the interrupt(s)
	REG_IF |= REG_IF;
};


void interrupt_init(void) {
  int i;

  // Set all interrupts to dummy functions.
  for(i = 0; i < 14; i ++) IntrTable[i] = (void (*)(void))interrupt_dummy;

  // Set selected interrupts to do something fun/useful.
  IntrTable[12] = (void (*)(void))interrupt_key;
	IntrTable[4] =  (void (*)(void))interrupt_sound;
}
