
#ifndef SPRITE_H
#define SPRITE_H

//define the screen width and height values to be used
#define SCREEN_WIDTH	240
#define SCREEN_HEIGHT   160

//colour convertion (converts a RGB colour to a 15-bit BGR value used by the GBA)
#define RGB16_BGR(r, g, b) ((r)+(g<<5)+(b<<10))

//attribute0 #defines
#define ROTATION_FLAG		0x100
#define SIZE_DOUBLE		0x200
#define MODE_NORMAL		0x0
#define MODE_TRANSPARENT	0x400
#define MODE_WINDOWED		0x800
#define MOSAIC			0x1000
#define COLOR_16		0x0000
#define COLOR_256		0x2000
#define SQUARE			0x0
#define TALL			0x4000
#define WIDE			0x8000

//attribute1 #defines
#define ROTDATA(n)		((n)<<9)
#define HORIZONTAL_FLIP		0x1000
#define VERTICAL_FLIP		0x2000
#define SIZE_8			0x0
#define SIZE_16			0x4000
#define SIZE_32			0x8000
#define SIZE_64			0xC000

//atrribute2 #defines
#define PRIORITY(n)	        ((n)<<10)
#define PALETTE(n)		((n)<<12)

//sprite structure definitions
typedef struct tagOAMEntry
{
	u16 attribute0;
	u16 attribute1;
	u16 attribute2;
	u16 attribute3;
}OAMEntry, *pOAMEntry;

//sprite rotation information (don't worry about this for now)
typedef struct tagRotData
{
	u16 filler1[3];
	u16 pa;
	u16 filler2[3];
	u16 pb;
	u16 filler3[3];
	u16 pc;
	u16 filler4[3];
	u16 pd;
}RotData, *pRotData;

extern OAMEntry sprites[128];
extern RotData* rotData;

void InitialiseSprites();
void CopyOAM();

typedef struct
{
	/* x and y co-ords */
	s16 x, y;
	/* x/y offset, width and height (for bounding box) */
	u16 bx, by, bw, bh;
	/* tile to draw with */
	u16 tile;
	/* priority */
	u16 pri;
	/* base values for attribues 0 and 1 */
	u16 a0, a1;
	/* sprite number */
	u16 sprite;
} Sprite;

#define DRAW_SPRITE(s) \
	sprites[s.sprite].attribute0 = s.a0 | (s.y & 0xff); \
	sprites[s.sprite].attribute1 = s.a1 | (s.x & 0x01ff); \
	sprites[s.sprite].attribute2 = s.tile | PRIORITY(s.pri);

#endif

/* sprite allocator */

#define NUM_SPRITES 128
u16 sprite_alloc();
void sprite_free(u16 sprite);

